package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RemoveThingType,
  OptionalVersion,
  ThingTypeName,
  ThingName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateThingRequest(
    thingName: ThingName,
    thingTypeName: Optional[ThingTypeName] = Optional.Absent,
    attributePayload: Optional[zio.aws.iot.model.AttributePayload] =
      Optional.Absent,
    expectedVersion: Optional[OptionalVersion] = Optional.Absent,
    removeThingType: Optional[RemoveThingType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateThingRequest = {
    import UpdateThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateThingRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .optionallyWith(attributePayload.map(value => value.buildAwsValue()))(
        _.attributePayload
      )
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .optionallyWith(
        removeThingType.map(value =>
          RemoveThingType.unwrap(value): java.lang.Boolean
        )
      )(_.removeThingType)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateThingRequest.ReadOnly =
    zio.aws.iot.model.UpdateThingRequest.wrap(buildAwsValue())
}
object UpdateThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateThingRequest =
      zio.aws.iot.model.UpdateThingRequest(
        thingName,
        thingTypeName.map(value => value),
        attributePayload.map(value => value.asEditable),
        expectedVersion.map(value => value),
        removeThingType.map(value => value)
      )
    def thingName: ThingName
    def thingTypeName: Optional[ThingTypeName]
    def attributePayload: Optional[zio.aws.iot.model.AttributePayload.ReadOnly]
    def expectedVersion: Optional[OptionalVersion]
    def removeThingType: Optional[RemoveThingType]
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
    def getAttributePayload
        : ZIO[Any, AwsError, zio.aws.iot.model.AttributePayload.ReadOnly] =
      AwsError.unwrapOptionField("attributePayload", attributePayload)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
    def getRemoveThingType: ZIO[Any, AwsError, RemoveThingType] =
      AwsError.unwrapOptionField("removeThingType", removeThingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateThingRequest
  ) extends zio.aws.iot.model.UpdateThingRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
    override val thingTypeName: Optional[ThingTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
    override val attributePayload
        : Optional[zio.aws.iot.model.AttributePayload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributePayload())
        .map(value => zio.aws.iot.model.AttributePayload.wrap(value))
    override val expectedVersion: Optional[OptionalVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedVersion())
        .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
    override val removeThingType: Optional[RemoveThingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeThingType())
        .map(value => zio.aws.iot.model.primitives.RemoveThingType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateThingRequest
  ): zio.aws.iot.model.UpdateThingRequest.ReadOnly = new Wrapper(impl)
}
