package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateTopicRuleDestinationRequest(
    arn: AwsArn,
    status: zio.aws.iot.model.TopicRuleDestinationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationRequest = {
    import UpdateTopicRuleDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationRequest
      .builder()
      .arn(AwsArn.unwrap(arn): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateTopicRuleDestinationRequest.ReadOnly =
    zio.aws.iot.model.UpdateTopicRuleDestinationRequest.wrap(buildAwsValue())
}
object UpdateTopicRuleDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateTopicRuleDestinationRequest =
      zio.aws.iot.model.UpdateTopicRuleDestinationRequest(arn, status)
    def arn: AwsArn
    def status: zio.aws.iot.model.TopicRuleDestinationStatus
    def getArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(arn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.iot.model.TopicRuleDestinationStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationRequest
  ) extends zio.aws.iot.model.UpdateTopicRuleDestinationRequest.ReadOnly {
    override val arn: AwsArn = zio.aws.iot.model.primitives.AwsArn(impl.arn())
    override val status: zio.aws.iot.model.TopicRuleDestinationStatus =
      zio.aws.iot.model.TopicRuleDestinationStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationRequest
  ): zio.aws.iot.model.UpdateTopicRuleDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
