package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AbortConfig(
    criteriaList: Iterable[zio.aws.iot.model.AbortCriteria]
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.AbortConfig = {
    import AbortConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AbortConfig
      .builder()
      .criteriaList(criteriaList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AbortConfig.ReadOnly =
    zio.aws.iot.model.AbortConfig.wrap(buildAwsValue())
}
object AbortConfig {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.AbortConfig] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AbortConfig =
      zio.aws.iot.model.AbortConfig(criteriaList.map { item =>
        item.asEditable
      })
    def criteriaList: List[zio.aws.iot.model.AbortCriteria.ReadOnly]
    def getCriteriaList
        : ZIO[Any, Nothing, List[zio.aws.iot.model.AbortCriteria.ReadOnly]] =
      ZIO.succeed(criteriaList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AbortConfig
  ) extends zio.aws.iot.model.AbortConfig.ReadOnly {
    override val criteriaList: List[zio.aws.iot.model.AbortCriteria.ReadOnly] =
      impl
        .criteriaList()
        .asScala
        .map { item =>
          zio.aws.iot.model.AbortCriteria.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AbortConfig
  ): zio.aws.iot.model.AbortConfig.ReadOnly = new Wrapper(impl)
}
