package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait AggregationTypeName {
  def unwrap: software.amazon.awssdk.services.iot.model.AggregationTypeName
}
object AggregationTypeName {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.AggregationTypeName
  ): zio.aws.iot.model.AggregationTypeName = value match {
    case software.amazon.awssdk.services.iot.model.AggregationTypeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.AggregationTypeName.STATISTICS =>
      val r = Statistics
      r
    case software.amazon.awssdk.services.iot.model.AggregationTypeName.PERCENTILES =>
      val r = Percentiles
      r
    case software.amazon.awssdk.services.iot.model.AggregationTypeName.CARDINALITY =>
      val r = Cardinality
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iot.model.AggregationTypeName {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AggregationTypeName =
      software.amazon.awssdk.services.iot.model.AggregationTypeName.UNKNOWN_TO_SDK_VERSION
  }
  case object Statistics extends zio.aws.iot.model.AggregationTypeName {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AggregationTypeName =
      software.amazon.awssdk.services.iot.model.AggregationTypeName.STATISTICS
  }
  case object Percentiles extends zio.aws.iot.model.AggregationTypeName {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AggregationTypeName =
      software.amazon.awssdk.services.iot.model.AggregationTypeName.PERCENTILES
  }
  case object Cardinality extends zio.aws.iot.model.AggregationTypeName {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AggregationTypeName =
      software.amazon.awssdk.services.iot.model.AggregationTypeName.CARDINALITY
  }
}
