package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Allowed(
    policies: Optional[Iterable[zio.aws.iot.model.Policy]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Allowed = {
    import Allowed.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Allowed
      .builder()
      .optionallyWith(
        policies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policies)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Allowed.ReadOnly =
    zio.aws.iot.model.Allowed.wrap(buildAwsValue())
}
object Allowed {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Allowed] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Allowed = zio.aws.iot.model.Allowed(
      policies.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def policies: Optional[List[zio.aws.iot.model.Policy.ReadOnly]]
    def getPolicies
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Policy.ReadOnly]] =
      AwsError.unwrapOptionField("policies", policies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Allowed
  ) extends zio.aws.iot.model.Allowed.ReadOnly {
    override val policies: Optional[List[zio.aws.iot.model.Policy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Policy.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Allowed
  ): zio.aws.iot.model.Allowed.ReadOnly = new Wrapper(impl)
}
