package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PolicyTarget, PolicyName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachPolicyRequest(
    policyName: PolicyName,
    target: PolicyTarget
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AttachPolicyRequest = {
    import AttachPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AttachPolicyRequest
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .target(PolicyTarget.unwrap(target): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AttachPolicyRequest.ReadOnly =
    zio.aws.iot.model.AttachPolicyRequest.wrap(buildAwsValue())
}
object AttachPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AttachPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AttachPolicyRequest =
      zio.aws.iot.model.AttachPolicyRequest(policyName, target)
    def policyName: PolicyName
    def target: PolicyTarget
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getTarget: ZIO[Any, Nothing, PolicyTarget] = ZIO.succeed(target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AttachPolicyRequest
  ) extends zio.aws.iot.model.AttachPolicyRequest.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.iot.model.primitives.PolicyName(impl.policyName())
    override val target: PolicyTarget =
      zio.aws.iot.model.primitives.PolicyTarget(impl.target())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AttachPolicyRequest
  ): zio.aws.iot.model.AttachPolicyRequest.ReadOnly = new Wrapper(impl)
}
