package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.MissingContextValue
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AuthResult(
    authInfo: Optional[zio.aws.iot.model.AuthInfo] = Optional.Absent,
    allowed: Optional[zio.aws.iot.model.Allowed] = Optional.Absent,
    denied: Optional[zio.aws.iot.model.Denied] = Optional.Absent,
    authDecision: Optional[zio.aws.iot.model.AuthDecision] = Optional.Absent,
    missingContextValues: Optional[Iterable[MissingContextValue]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.AuthResult = {
    import AuthResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuthResult
      .builder()
      .optionallyWith(authInfo.map(value => value.buildAwsValue()))(_.authInfo)
      .optionallyWith(allowed.map(value => value.buildAwsValue()))(_.allowed)
      .optionallyWith(denied.map(value => value.buildAwsValue()))(_.denied)
      .optionallyWith(authDecision.map(value => value.unwrap))(_.authDecision)
      .optionallyWith(
        missingContextValues.map(value =>
          value.map { item =>
            MissingContextValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.missingContextValues)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuthResult.ReadOnly =
    zio.aws.iot.model.AuthResult.wrap(buildAwsValue())
}
object AuthResult {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.AuthResult] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuthResult = zio.aws.iot.model.AuthResult(
      authInfo.map(value => value.asEditable),
      allowed.map(value => value.asEditable),
      denied.map(value => value.asEditable),
      authDecision.map(value => value),
      missingContextValues.map(value => value)
    )
    def authInfo: Optional[zio.aws.iot.model.AuthInfo.ReadOnly]
    def allowed: Optional[zio.aws.iot.model.Allowed.ReadOnly]
    def denied: Optional[zio.aws.iot.model.Denied.ReadOnly]
    def authDecision: Optional[zio.aws.iot.model.AuthDecision]
    def missingContextValues: Optional[List[MissingContextValue]]
    def getAuthInfo: ZIO[Any, AwsError, zio.aws.iot.model.AuthInfo.ReadOnly] =
      AwsError.unwrapOptionField("authInfo", authInfo)
    def getAllowed: ZIO[Any, AwsError, zio.aws.iot.model.Allowed.ReadOnly] =
      AwsError.unwrapOptionField("allowed", allowed)
    def getDenied: ZIO[Any, AwsError, zio.aws.iot.model.Denied.ReadOnly] =
      AwsError.unwrapOptionField("denied", denied)
    def getAuthDecision: ZIO[Any, AwsError, zio.aws.iot.model.AuthDecision] =
      AwsError.unwrapOptionField("authDecision", authDecision)
    def getMissingContextValues: ZIO[Any, AwsError, List[MissingContextValue]] =
      AwsError.unwrapOptionField("missingContextValues", missingContextValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuthResult
  ) extends zio.aws.iot.model.AuthResult.ReadOnly {
    override val authInfo: Optional[zio.aws.iot.model.AuthInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authInfo())
        .map(value => zio.aws.iot.model.AuthInfo.wrap(value))
    override val allowed: Optional[zio.aws.iot.model.Allowed.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowed())
        .map(value => zio.aws.iot.model.Allowed.wrap(value))
    override val denied: Optional[zio.aws.iot.model.Denied.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.denied())
        .map(value => zio.aws.iot.model.Denied.wrap(value))
    override val authDecision: Optional[zio.aws.iot.model.AuthDecision] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authDecision())
        .map(value => zio.aws.iot.model.AuthDecision.wrap(value))
    override val missingContextValues: Optional[List[MissingContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.missingContextValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.MissingContextValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuthResult
  ): zio.aws.iot.model.AuthResult.ReadOnly = new Wrapper(impl)
}
