package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AwsJobRolloutIncrementFactor,
  AwsJobRolloutRatePerMinute
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AwsJobExponentialRolloutRate(
    baseRatePerMinute: AwsJobRolloutRatePerMinute,
    incrementFactor: AwsJobRolloutIncrementFactor,
    rateIncreaseCriteria: zio.aws.iot.model.AwsJobRateIncreaseCriteria
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AwsJobExponentialRolloutRate = {
    import AwsJobExponentialRolloutRate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AwsJobExponentialRolloutRate
      .builder()
      .baseRatePerMinute(
        AwsJobRolloutRatePerMinute.unwrap(baseRatePerMinute): Integer
      )
      .incrementFactor(
        AwsJobRolloutIncrementFactor.unwrap(incrementFactor): java.lang.Double
      )
      .rateIncreaseCriteria(rateIncreaseCriteria.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AwsJobExponentialRolloutRate.ReadOnly =
    zio.aws.iot.model.AwsJobExponentialRolloutRate.wrap(buildAwsValue())
}
object AwsJobExponentialRolloutRate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AwsJobExponentialRolloutRate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AwsJobExponentialRolloutRate =
      zio.aws.iot.model.AwsJobExponentialRolloutRate(
        baseRatePerMinute,
        incrementFactor,
        rateIncreaseCriteria.asEditable
      )
    def baseRatePerMinute: AwsJobRolloutRatePerMinute
    def incrementFactor: AwsJobRolloutIncrementFactor
    def rateIncreaseCriteria
        : zio.aws.iot.model.AwsJobRateIncreaseCriteria.ReadOnly
    def getBaseRatePerMinute: ZIO[Any, Nothing, AwsJobRolloutRatePerMinute] =
      ZIO.succeed(baseRatePerMinute)
    def getIncrementFactor: ZIO[Any, Nothing, AwsJobRolloutIncrementFactor] =
      ZIO.succeed(incrementFactor)
    def getRateIncreaseCriteria: ZIO[
      Any,
      Nothing,
      zio.aws.iot.model.AwsJobRateIncreaseCriteria.ReadOnly
    ] = ZIO.succeed(rateIncreaseCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AwsJobExponentialRolloutRate
  ) extends zio.aws.iot.model.AwsJobExponentialRolloutRate.ReadOnly {
    override val baseRatePerMinute: AwsJobRolloutRatePerMinute =
      zio.aws.iot.model.primitives
        .AwsJobRolloutRatePerMinute(impl.baseRatePerMinute())
    override val incrementFactor: AwsJobRolloutIncrementFactor =
      zio.aws.iot.model.primitives
        .AwsJobRolloutIncrementFactor(impl.incrementFactor())
    override val rateIncreaseCriteria
        : zio.aws.iot.model.AwsJobRateIncreaseCriteria.ReadOnly =
      zio.aws.iot.model.AwsJobRateIncreaseCriteria
        .wrap(impl.rateIncreaseCriteria())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AwsJobExponentialRolloutRate
  ): zio.aws.iot.model.AwsJobExponentialRolloutRate.ReadOnly = new Wrapper(impl)
}
