package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DataCollectionPercentage,
  Timestamp,
  BehaviorName,
  SecurityProfileName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class BehaviorModelTrainingSummary(
    securityProfileName: Optional[SecurityProfileName] = Optional.Absent,
    behaviorName: Optional[BehaviorName] = Optional.Absent,
    trainingDataCollectionStartDate: Optional[Timestamp] = Optional.Absent,
    modelStatus: Optional[zio.aws.iot.model.ModelStatus] = Optional.Absent,
    datapointsCollectionPercentage: Optional[DataCollectionPercentage] =
      Optional.Absent,
    lastModelRefreshDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.BehaviorModelTrainingSummary = {
    import BehaviorModelTrainingSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.BehaviorModelTrainingSummary
      .builder()
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(
        behaviorName.map(value => BehaviorName.unwrap(value): java.lang.String)
      )(_.behaviorName)
      .optionallyWith(
        trainingDataCollectionStartDate.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.trainingDataCollectionStartDate)
      .optionallyWith(modelStatus.map(value => value.unwrap))(_.modelStatus)
      .optionallyWith(
        datapointsCollectionPercentage.map(value =>
          DataCollectionPercentage.unwrap(value): java.lang.Double
        )
      )(_.datapointsCollectionPercentage)
      .optionallyWith(
        lastModelRefreshDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModelRefreshDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.BehaviorModelTrainingSummary.ReadOnly =
    zio.aws.iot.model.BehaviorModelTrainingSummary.wrap(buildAwsValue())
}
object BehaviorModelTrainingSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.BehaviorModelTrainingSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.BehaviorModelTrainingSummary =
      zio.aws.iot.model.BehaviorModelTrainingSummary(
        securityProfileName.map(value => value),
        behaviorName.map(value => value),
        trainingDataCollectionStartDate.map(value => value),
        modelStatus.map(value => value),
        datapointsCollectionPercentage.map(value => value),
        lastModelRefreshDate.map(value => value)
      )
    def securityProfileName: Optional[SecurityProfileName]
    def behaviorName: Optional[BehaviorName]
    def trainingDataCollectionStartDate: Optional[Timestamp]
    def modelStatus: Optional[zio.aws.iot.model.ModelStatus]
    def datapointsCollectionPercentage: Optional[DataCollectionPercentage]
    def lastModelRefreshDate: Optional[Timestamp]
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getBehaviorName: ZIO[Any, AwsError, BehaviorName] =
      AwsError.unwrapOptionField("behaviorName", behaviorName)
    def getTrainingDataCollectionStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "trainingDataCollectionStartDate",
        trainingDataCollectionStartDate
      )
    def getModelStatus: ZIO[Any, AwsError, zio.aws.iot.model.ModelStatus] =
      AwsError.unwrapOptionField("modelStatus", modelStatus)
    def getDatapointsCollectionPercentage
        : ZIO[Any, AwsError, DataCollectionPercentage] =
      AwsError.unwrapOptionField(
        "datapointsCollectionPercentage",
        datapointsCollectionPercentage
      )
    def getLastModelRefreshDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModelRefreshDate", lastModelRefreshDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.BehaviorModelTrainingSummary
  ) extends zio.aws.iot.model.BehaviorModelTrainingSummary.ReadOnly {
    override val securityProfileName: Optional[SecurityProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileName())
        .map(value => zio.aws.iot.model.primitives.SecurityProfileName(value))
    override val behaviorName: Optional[BehaviorName] = zio.aws.core.internal
      .optionalFromNullable(impl.behaviorName())
      .map(value => zio.aws.iot.model.primitives.BehaviorName(value))
    override val trainingDataCollectionStartDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingDataCollectionStartDate())
        .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val modelStatus: Optional[zio.aws.iot.model.ModelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelStatus())
        .map(value => zio.aws.iot.model.ModelStatus.wrap(value))
    override val datapointsCollectionPercentage
        : Optional[DataCollectionPercentage] = zio.aws.core.internal
      .optionalFromNullable(impl.datapointsCollectionPercentage())
      .map(value =>
        zio.aws.iot.model.primitives.DataCollectionPercentage(value)
      )
    override val lastModelRefreshDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModelRefreshDate())
        .map(value => zio.aws.iot.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.BehaviorModelTrainingSummary
  ): zio.aws.iot.model.BehaviorModelTrainingSummary.ReadOnly = new Wrapper(impl)
}
