package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.CreationDate
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class BillingGroupMetadata(
    creationDate: Optional[CreationDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.BillingGroupMetadata = {
    import BillingGroupMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.BillingGroupMetadata
      .builder()
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.BillingGroupMetadata.ReadOnly =
    zio.aws.iot.model.BillingGroupMetadata.wrap(buildAwsValue())
}
object BillingGroupMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.BillingGroupMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.BillingGroupMetadata =
      zio.aws.iot.model.BillingGroupMetadata(creationDate.map(value => value))
    def creationDate: Optional[CreationDate]
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.BillingGroupMetadata
  ) extends zio.aws.iot.model.BillingGroupMetadata.ReadOnly {
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.CreationDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.BillingGroupMetadata
  ): zio.aws.iot.model.BillingGroupMetadata.ReadOnly = new Wrapper(impl)
}
