package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.MitigationActionsTaskId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelAuditMitigationActionsTaskRequest(
    taskId: MitigationActionsTaskId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskRequest = {
    import CancelAuditMitigationActionsTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskRequest
      .builder()
      .taskId(MitigationActionsTaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.CancelAuditMitigationActionsTaskRequest.ReadOnly =
    zio.aws.iot.model.CancelAuditMitigationActionsTaskRequest
      .wrap(buildAwsValue())
}
object CancelAuditMitigationActionsTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CancelAuditMitigationActionsTaskRequest =
      zio.aws.iot.model.CancelAuditMitigationActionsTaskRequest(taskId)
    def taskId: MitigationActionsTaskId
    def getTaskId: ZIO[Any, Nothing, MitigationActionsTaskId] =
      ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskRequest
  ) extends zio.aws.iot.model.CancelAuditMitigationActionsTaskRequest.ReadOnly {
    override val taskId: MitigationActionsTaskId =
      zio.aws.iot.model.primitives.MitigationActionsTaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskRequest
  ): zio.aws.iot.model.CancelAuditMitigationActionsTaskRequest.ReadOnly =
    new Wrapper(impl)
}
