package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{LogGroupName, AwsArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CloudwatchLogsAction(
    roleArn: AwsArn,
    logGroupName: LogGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CloudwatchLogsAction = {
    import CloudwatchLogsAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CloudwatchLogsAction
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .logGroupName(LogGroupName.unwrap(logGroupName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CloudwatchLogsAction.ReadOnly =
    zio.aws.iot.model.CloudwatchLogsAction.wrap(buildAwsValue())
}
object CloudwatchLogsAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CloudwatchLogsAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CloudwatchLogsAction =
      zio.aws.iot.model.CloudwatchLogsAction(roleArn, logGroupName)
    def roleArn: AwsArn
    def logGroupName: LogGroupName
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getLogGroupName: ZIO[Any, Nothing, LogGroupName] =
      ZIO.succeed(logGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CloudwatchLogsAction
  ) extends zio.aws.iot.model.CloudwatchLogsAction.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val logGroupName: LogGroupName =
      zio.aws.iot.model.primitives.LogGroupName(impl.logGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CloudwatchLogsAction
  ): zio.aws.iot.model.CloudwatchLogsAction.ReadOnly = new Wrapper(impl)
}
