package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{InlineDocument, CertificateName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CodeSigningCertificateChain(
    certificateName: Optional[CertificateName] = Optional.Absent,
    inlineDocument: Optional[InlineDocument] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain = {
    import CodeSigningCertificateChain.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain
      .builder()
      .optionallyWith(
        certificateName.map(value =>
          CertificateName.unwrap(value): java.lang.String
        )
      )(_.certificateName)
      .optionallyWith(
        inlineDocument.map(value =>
          InlineDocument.unwrap(value): java.lang.String
        )
      )(_.inlineDocument)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CodeSigningCertificateChain.ReadOnly =
    zio.aws.iot.model.CodeSigningCertificateChain.wrap(buildAwsValue())
}
object CodeSigningCertificateChain {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CodeSigningCertificateChain =
      zio.aws.iot.model.CodeSigningCertificateChain(
        certificateName.map(value => value),
        inlineDocument.map(value => value)
      )
    def certificateName: Optional[CertificateName]
    def inlineDocument: Optional[InlineDocument]
    def getCertificateName: ZIO[Any, AwsError, CertificateName] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getInlineDocument: ZIO[Any, AwsError, InlineDocument] =
      AwsError.unwrapOptionField("inlineDocument", inlineDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain
  ) extends zio.aws.iot.model.CodeSigningCertificateChain.ReadOnly {
    override val certificateName: Optional[CertificateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateName())
        .map(value => zio.aws.iot.model.primitives.CertificateName(value))
    override val inlineDocument: Optional[InlineDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inlineDocument())
        .map(value => zio.aws.iot.model.primitives.InlineDocument(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain
  ): zio.aws.iot.model.CodeSigningCertificateChain.ReadOnly = new Wrapper(impl)
}
