package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.BillingGroupName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateBillingGroupRequest(
    billingGroupName: BillingGroupName,
    billingGroupProperties: Optional[zio.aws.iot.model.BillingGroupProperties] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateBillingGroupRequest = {
    import CreateBillingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateBillingGroupRequest
      .builder()
      .billingGroupName(
        BillingGroupName.unwrap(billingGroupName): java.lang.String
      )
      .optionallyWith(
        billingGroupProperties.map(value => value.buildAwsValue())
      )(_.billingGroupProperties)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateBillingGroupRequest.ReadOnly =
    zio.aws.iot.model.CreateBillingGroupRequest.wrap(buildAwsValue())
}
object CreateBillingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateBillingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateBillingGroupRequest =
      zio.aws.iot.model.CreateBillingGroupRequest(
        billingGroupName,
        billingGroupProperties.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def billingGroupName: BillingGroupName
    def billingGroupProperties
        : Optional[zio.aws.iot.model.BillingGroupProperties.ReadOnly]
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getBillingGroupName: ZIO[Any, Nothing, BillingGroupName] =
      ZIO.succeed(billingGroupName)
    def getBillingGroupProperties: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.BillingGroupProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "billingGroupProperties",
      billingGroupProperties
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateBillingGroupRequest
  ) extends zio.aws.iot.model.CreateBillingGroupRequest.ReadOnly {
    override val billingGroupName: BillingGroupName =
      zio.aws.iot.model.primitives.BillingGroupName(impl.billingGroupName())
    override val billingGroupProperties
        : Optional[zio.aws.iot.model.BillingGroupProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupProperties())
        .map(value => zio.aws.iot.model.BillingGroupProperties.wrap(value))
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateBillingGroupRequest
  ): zio.aws.iot.model.CreateBillingGroupRequest.ReadOnly = new Wrapper(impl)
}
