package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  BillingGroupId,
  BillingGroupArn,
  BillingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateBillingGroupResponse(
    billingGroupName: Optional[BillingGroupName] = Optional.Absent,
    billingGroupArn: Optional[BillingGroupArn] = Optional.Absent,
    billingGroupId: Optional[BillingGroupId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateBillingGroupResponse = {
    import CreateBillingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateBillingGroupResponse
      .builder()
      .optionallyWith(
        billingGroupName.map(value =>
          BillingGroupName.unwrap(value): java.lang.String
        )
      )(_.billingGroupName)
      .optionallyWith(
        billingGroupArn.map(value =>
          BillingGroupArn.unwrap(value): java.lang.String
        )
      )(_.billingGroupArn)
      .optionallyWith(
        billingGroupId.map(value =>
          BillingGroupId.unwrap(value): java.lang.String
        )
      )(_.billingGroupId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateBillingGroupResponse.ReadOnly =
    zio.aws.iot.model.CreateBillingGroupResponse.wrap(buildAwsValue())
}
object CreateBillingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateBillingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateBillingGroupResponse =
      zio.aws.iot.model.CreateBillingGroupResponse(
        billingGroupName.map(value => value),
        billingGroupArn.map(value => value),
        billingGroupId.map(value => value)
      )
    def billingGroupName: Optional[BillingGroupName]
    def billingGroupArn: Optional[BillingGroupArn]
    def billingGroupId: Optional[BillingGroupId]
    def getBillingGroupName: ZIO[Any, AwsError, BillingGroupName] =
      AwsError.unwrapOptionField("billingGroupName", billingGroupName)
    def getBillingGroupArn: ZIO[Any, AwsError, BillingGroupArn] =
      AwsError.unwrapOptionField("billingGroupArn", billingGroupArn)
    def getBillingGroupId: ZIO[Any, AwsError, BillingGroupId] =
      AwsError.unwrapOptionField("billingGroupId", billingGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateBillingGroupResponse
  ) extends zio.aws.iot.model.CreateBillingGroupResponse.ReadOnly {
    override val billingGroupName: Optional[BillingGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupName())
        .map(value => zio.aws.iot.model.primitives.BillingGroupName(value))
    override val billingGroupArn: Optional[BillingGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupArn())
        .map(value => zio.aws.iot.model.primitives.BillingGroupArn(value))
    override val billingGroupId: Optional[BillingGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupId())
        .map(value => zio.aws.iot.model.primitives.BillingGroupId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateBillingGroupResponse
  ): zio.aws.iot.model.CreateBillingGroupResponse.ReadOnly = new Wrapper(impl)
}
