package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  IndexName,
  AggregationField,
  FleetMetricPeriod,
  FleetMetricDescription,
  FleetMetricName,
  QueryVersion,
  QueryString
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateFleetMetricRequest(
    metricName: FleetMetricName,
    queryString: QueryString,
    aggregationType: zio.aws.iot.model.AggregationType,
    period: FleetMetricPeriod,
    aggregationField: AggregationField,
    description: Optional[FleetMetricDescription] = Optional.Absent,
    queryVersion: Optional[QueryVersion] = Optional.Absent,
    indexName: Optional[IndexName] = Optional.Absent,
    unit: Optional[zio.aws.iot.model.FleetMetricUnit] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateFleetMetricRequest = {
    import CreateFleetMetricRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateFleetMetricRequest
      .builder()
      .metricName(FleetMetricName.unwrap(metricName): java.lang.String)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .aggregationType(aggregationType.buildAwsValue())
      .period(FleetMetricPeriod.unwrap(period): Integer)
      .aggregationField(
        AggregationField.unwrap(aggregationField): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          FleetMetricDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateFleetMetricRequest.ReadOnly =
    zio.aws.iot.model.CreateFleetMetricRequest.wrap(buildAwsValue())
}
object CreateFleetMetricRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateFleetMetricRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateFleetMetricRequest =
      zio.aws.iot.model.CreateFleetMetricRequest(
        metricName,
        queryString,
        aggregationType.asEditable,
        period,
        aggregationField,
        description.map(value => value),
        queryVersion.map(value => value),
        indexName.map(value => value),
        unit.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricName: FleetMetricName
    def queryString: QueryString
    def aggregationType: zio.aws.iot.model.AggregationType.ReadOnly
    def period: FleetMetricPeriod
    def aggregationField: AggregationField
    def description: Optional[FleetMetricDescription]
    def queryVersion: Optional[QueryVersion]
    def indexName: Optional[IndexName]
    def unit: Optional[zio.aws.iot.model.FleetMetricUnit]
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getMetricName: ZIO[Any, Nothing, FleetMetricName] =
      ZIO.succeed(metricName)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getAggregationType
        : ZIO[Any, Nothing, zio.aws.iot.model.AggregationType.ReadOnly] =
      ZIO.succeed(aggregationType)
    def getPeriod: ZIO[Any, Nothing, FleetMetricPeriod] = ZIO.succeed(period)
    def getAggregationField: ZIO[Any, Nothing, AggregationField] =
      ZIO.succeed(aggregationField)
    def getDescription: ZIO[Any, AwsError, FleetMetricDescription] =
      AwsError.unwrapOptionField("description", description)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getUnit: ZIO[Any, AwsError, zio.aws.iot.model.FleetMetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateFleetMetricRequest
  ) extends zio.aws.iot.model.CreateFleetMetricRequest.ReadOnly {
    override val metricName: FleetMetricName =
      zio.aws.iot.model.primitives.FleetMetricName(impl.metricName())
    override val queryString: QueryString =
      zio.aws.iot.model.primitives.QueryString(impl.queryString())
    override val aggregationType: zio.aws.iot.model.AggregationType.ReadOnly =
      zio.aws.iot.model.AggregationType.wrap(impl.aggregationType())
    override val period: FleetMetricPeriod =
      zio.aws.iot.model.primitives.FleetMetricPeriod(impl.period())
    override val aggregationField: AggregationField =
      zio.aws.iot.model.primitives.AggregationField(impl.aggregationField())
    override val description: Optional[FleetMetricDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.iot.model.primitives.FleetMetricDescription(value)
        )
    override val queryVersion: Optional[QueryVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val unit: Optional[zio.aws.iot.model.FleetMetricUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.iot.model.FleetMetricUnit.wrap(value))
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateFleetMetricRequest
  ): zio.aws.iot.model.CreateFleetMetricRequest.ReadOnly = new Wrapper(impl)
}
