package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  PolicyVersionId,
  PolicyDocument,
  PolicyArn,
  PolicyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePolicyResponse(
    policyName: Optional[PolicyName] = Optional.Absent,
    policyArn: Optional[PolicyArn] = Optional.Absent,
    policyDocument: Optional[PolicyDocument] = Optional.Absent,
    policyVersionId: Optional[PolicyVersionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreatePolicyResponse = {
    import CreatePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreatePolicyResponse
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyArn.map(value => PolicyArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .optionallyWith(
        policyDocument.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policyDocument)
      .optionallyWith(
        policyVersionId.map(value =>
          PolicyVersionId.unwrap(value): java.lang.String
        )
      )(_.policyVersionId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreatePolicyResponse.ReadOnly =
    zio.aws.iot.model.CreatePolicyResponse.wrap(buildAwsValue())
}
object CreatePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreatePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreatePolicyResponse =
      zio.aws.iot.model.CreatePolicyResponse(
        policyName.map(value => value),
        policyArn.map(value => value),
        policyDocument.map(value => value),
        policyVersionId.map(value => value)
      )
    def policyName: Optional[PolicyName]
    def policyArn: Optional[PolicyArn]
    def policyDocument: Optional[PolicyDocument]
    def policyVersionId: Optional[PolicyVersionId]
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyArn: ZIO[Any, AwsError, PolicyArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
    def getPolicyDocument: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getPolicyVersionId: ZIO[Any, AwsError, PolicyVersionId] =
      AwsError.unwrapOptionField("policyVersionId", policyVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreatePolicyResponse
  ) extends zio.aws.iot.model.CreatePolicyResponse.ReadOnly {
    override val policyName: Optional[PolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.iot.model.primitives.PolicyName(value))
    override val policyArn: Optional[PolicyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.policyArn())
      .map(value => zio.aws.iot.model.primitives.PolicyArn(value))
    override val policyDocument: Optional[PolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDocument())
        .map(value => zio.aws.iot.model.primitives.PolicyDocument(value))
    override val policyVersionId: Optional[PolicyVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyVersionId())
        .map(value => zio.aws.iot.model.primitives.PolicyVersionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreatePolicyResponse
  ): zio.aws.iot.model.CreatePolicyResponse.ReadOnly = new Wrapper(impl)
}
