package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{SetAsDefault, TemplateBody, TemplateName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateProvisioningTemplateVersionRequest(
    templateName: TemplateName,
    templateBody: TemplateBody,
    setAsDefault: Optional[SetAsDefault] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionRequest = {
    import CreateProvisioningTemplateVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .templateBody(TemplateBody.unwrap(templateBody): java.lang.String)
      .optionallyWith(
        setAsDefault.map(value => SetAsDefault.unwrap(value): java.lang.Boolean)
      )(_.setAsDefault)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.CreateProvisioningTemplateVersionRequest.ReadOnly =
    zio.aws.iot.model.CreateProvisioningTemplateVersionRequest
      .wrap(buildAwsValue())
}
object CreateProvisioningTemplateVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateProvisioningTemplateVersionRequest =
      zio.aws.iot.model.CreateProvisioningTemplateVersionRequest(
        templateName,
        templateBody,
        setAsDefault.map(value => value)
      )
    def templateName: TemplateName
    def templateBody: TemplateBody
    def setAsDefault: Optional[SetAsDefault]
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getTemplateBody: ZIO[Any, Nothing, TemplateBody] =
      ZIO.succeed(templateBody)
    def getSetAsDefault: ZIO[Any, AwsError, SetAsDefault] =
      AwsError.unwrapOptionField("setAsDefault", setAsDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionRequest
  ) extends zio.aws.iot.model.CreateProvisioningTemplateVersionRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.iot.model.primitives.TemplateName(impl.templateName())
    override val templateBody: TemplateBody =
      zio.aws.iot.model.primitives.TemplateBody(impl.templateBody())
    override val setAsDefault: Optional[SetAsDefault] = zio.aws.core.internal
      .optionalFromNullable(impl.setAsDefault())
      .map(value => zio.aws.iot.model.primitives.SetAsDefault(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionRequest
  ): zio.aws.iot.model.CreateProvisioningTemplateVersionRequest.ReadOnly =
    new Wrapper(impl)
}
