package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  CredentialDurationSeconds,
  RoleArn,
  RoleAlias
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateRoleAliasRequest(
    roleAlias: RoleAlias,
    roleArn: RoleArn,
    credentialDurationSeconds: Optional[CredentialDurationSeconds] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateRoleAliasRequest = {
    import CreateRoleAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateRoleAliasRequest
      .builder()
      .roleAlias(RoleAlias.unwrap(roleAlias): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        credentialDurationSeconds.map(value =>
          CredentialDurationSeconds.unwrap(value): Integer
        )
      )(_.credentialDurationSeconds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateRoleAliasRequest.ReadOnly =
    zio.aws.iot.model.CreateRoleAliasRequest.wrap(buildAwsValue())
}
object CreateRoleAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateRoleAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateRoleAliasRequest =
      zio.aws.iot.model.CreateRoleAliasRequest(
        roleAlias,
        roleArn,
        credentialDurationSeconds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def roleAlias: RoleAlias
    def roleArn: RoleArn
    def credentialDurationSeconds: Optional[CredentialDurationSeconds]
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getRoleAlias: ZIO[Any, Nothing, RoleAlias] = ZIO.succeed(roleAlias)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getCredentialDurationSeconds
        : ZIO[Any, AwsError, CredentialDurationSeconds] = AwsError
      .unwrapOptionField("credentialDurationSeconds", credentialDurationSeconds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateRoleAliasRequest
  ) extends zio.aws.iot.model.CreateRoleAliasRequest.ReadOnly {
    override val roleAlias: RoleAlias =
      zio.aws.iot.model.primitives.RoleAlias(impl.roleAlias())
    override val roleArn: RoleArn =
      zio.aws.iot.model.primitives.RoleArn(impl.roleArn())
    override val credentialDurationSeconds
        : Optional[CredentialDurationSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.credentialDurationSeconds())
      .map(value =>
        zio.aws.iot.model.primitives.CredentialDurationSeconds(value)
      )
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateRoleAliasRequest
  ): zio.aws.iot.model.CreateRoleAliasRequest.ReadOnly = new Wrapper(impl)
}
