package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingGroupId,
  ThingGroupArn,
  ThingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateThingGroupResponse(
    thingGroupName: Optional[ThingGroupName] = Optional.Absent,
    thingGroupArn: Optional[ThingGroupArn] = Optional.Absent,
    thingGroupId: Optional[ThingGroupId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateThingGroupResponse = {
    import CreateThingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateThingGroupResponse
      .builder()
      .optionallyWith(
        thingGroupName.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.thingGroupName)
      .optionallyWith(
        thingGroupArn.map(value =>
          ThingGroupArn.unwrap(value): java.lang.String
        )
      )(_.thingGroupArn)
      .optionallyWith(
        thingGroupId.map(value => ThingGroupId.unwrap(value): java.lang.String)
      )(_.thingGroupId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateThingGroupResponse.ReadOnly =
    zio.aws.iot.model.CreateThingGroupResponse.wrap(buildAwsValue())
}
object CreateThingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateThingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateThingGroupResponse =
      zio.aws.iot.model.CreateThingGroupResponse(
        thingGroupName.map(value => value),
        thingGroupArn.map(value => value),
        thingGroupId.map(value => value)
      )
    def thingGroupName: Optional[ThingGroupName]
    def thingGroupArn: Optional[ThingGroupArn]
    def thingGroupId: Optional[ThingGroupId]
    def getThingGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("thingGroupName", thingGroupName)
    def getThingGroupArn: ZIO[Any, AwsError, ThingGroupArn] =
      AwsError.unwrapOptionField("thingGroupArn", thingGroupArn)
    def getThingGroupId: ZIO[Any, AwsError, ThingGroupId] =
      AwsError.unwrapOptionField("thingGroupId", thingGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateThingGroupResponse
  ) extends zio.aws.iot.model.CreateThingGroupResponse.ReadOnly {
    override val thingGroupName: Optional[ThingGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingGroupName())
        .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val thingGroupArn: Optional[ThingGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingGroupArn())
      .map(value => zio.aws.iot.model.primitives.ThingGroupArn(value))
    override val thingGroupId: Optional[ThingGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.thingGroupId())
      .map(value => zio.aws.iot.model.primitives.ThingGroupId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateThingGroupResponse
  ): zio.aws.iot.model.CreateThingGroupResponse.ReadOnly = new Wrapper(impl)
}
