package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ThingTypeName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateThingTypeRequest(
    thingTypeName: ThingTypeName,
    thingTypeProperties: Optional[zio.aws.iot.model.ThingTypeProperties] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateThingTypeRequest = {
    import CreateThingTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateThingTypeRequest
      .builder()
      .thingTypeName(ThingTypeName.unwrap(thingTypeName): java.lang.String)
      .optionallyWith(thingTypeProperties.map(value => value.buildAwsValue()))(
        _.thingTypeProperties
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateThingTypeRequest.ReadOnly =
    zio.aws.iot.model.CreateThingTypeRequest.wrap(buildAwsValue())
}
object CreateThingTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateThingTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateThingTypeRequest =
      zio.aws.iot.model.CreateThingTypeRequest(
        thingTypeName,
        thingTypeProperties.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def thingTypeName: ThingTypeName
    def thingTypeProperties
        : Optional[zio.aws.iot.model.ThingTypeProperties.ReadOnly]
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getThingTypeName: ZIO[Any, Nothing, ThingTypeName] =
      ZIO.succeed(thingTypeName)
    def getThingTypeProperties
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingTypeProperties.ReadOnly] =
      AwsError.unwrapOptionField("thingTypeProperties", thingTypeProperties)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateThingTypeRequest
  ) extends zio.aws.iot.model.CreateThingTypeRequest.ReadOnly {
    override val thingTypeName: ThingTypeName =
      zio.aws.iot.model.primitives.ThingTypeName(impl.thingTypeName())
    override val thingTypeProperties
        : Optional[zio.aws.iot.model.ThingTypeProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingTypeProperties())
        .map(value => zio.aws.iot.model.ThingTypeProperties.wrap(value))
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateThingTypeRequest
  ): zio.aws.iot.model.CreateThingTypeRequest.ReadOnly = new Wrapper(impl)
}
