package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateTopicRuleDestinationResponse(
    topicRuleDestination: Optional[zio.aws.iot.model.TopicRuleDestination] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse = {
    import CreateTopicRuleDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse
      .builder()
      .optionallyWith(topicRuleDestination.map(value => value.buildAwsValue()))(
        _.topicRuleDestination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.CreateTopicRuleDestinationResponse.ReadOnly =
    zio.aws.iot.model.CreateTopicRuleDestinationResponse.wrap(buildAwsValue())
}
object CreateTopicRuleDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateTopicRuleDestinationResponse =
      zio.aws.iot.model.CreateTopicRuleDestinationResponse(
        topicRuleDestination.map(value => value.asEditable)
      )
    def topicRuleDestination
        : Optional[zio.aws.iot.model.TopicRuleDestination.ReadOnly]
    def getTopicRuleDestination
        : ZIO[Any, AwsError, zio.aws.iot.model.TopicRuleDestination.ReadOnly] =
      AwsError.unwrapOptionField("topicRuleDestination", topicRuleDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse
  ) extends zio.aws.iot.model.CreateTopicRuleDestinationResponse.ReadOnly {
    override val topicRuleDestination
        : Optional[zio.aws.iot.model.TopicRuleDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicRuleDestination())
        .map(value => zio.aws.iot.model.TopicRuleDestination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse
  ): zio.aws.iot.model.CreateTopicRuleDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
