package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.RuleName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateTopicRuleRequest(
    ruleName: RuleName,
    topicRulePayload: zio.aws.iot.model.TopicRulePayload,
    tags: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest = {
    import CreateTopicRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest
      .builder()
      .ruleName(RuleName.unwrap(ruleName): java.lang.String)
      .topicRulePayload(topicRulePayload.buildAwsValue())
      .optionallyWith(tags.map(value => value: java.lang.String))(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateTopicRuleRequest.ReadOnly =
    zio.aws.iot.model.CreateTopicRuleRequest.wrap(buildAwsValue())
}
object CreateTopicRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateTopicRuleRequest =
      zio.aws.iot.model.CreateTopicRuleRequest(
        ruleName,
        topicRulePayload.asEditable,
        tags.map(value => value)
      )
    def ruleName: RuleName
    def topicRulePayload: zio.aws.iot.model.TopicRulePayload.ReadOnly
    def tags: Optional[String]
    def getRuleName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(ruleName)
    def getTopicRulePayload
        : ZIO[Any, Nothing, zio.aws.iot.model.TopicRulePayload.ReadOnly] =
      ZIO.succeed(topicRulePayload)
    def getTags: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest
  ) extends zio.aws.iot.model.CreateTopicRuleRequest.ReadOnly {
    override val ruleName: RuleName =
      zio.aws.iot.model.primitives.RuleName(impl.ruleName())
    override val topicRulePayload: zio.aws.iot.model.TopicRulePayload.ReadOnly =
      zio.aws.iot.model.TopicRulePayload.wrap(impl.topicRulePayload())
    override val tags: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest
  ): zio.aws.iot.model.CreateTopicRuleRequest.ReadOnly = new Wrapper(impl)
}
