package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.MitigationActionsTaskId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeAuditMitigationActionsTaskRequest(
    taskId: MitigationActionsTaskId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskRequest = {
    import DescribeAuditMitigationActionsTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskRequest
      .builder()
      .taskId(MitigationActionsTaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeAuditMitigationActionsTaskRequest.ReadOnly =
    zio.aws.iot.model.DescribeAuditMitigationActionsTaskRequest
      .wrap(buildAwsValue())
}
object DescribeAuditMitigationActionsTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.DescribeAuditMitigationActionsTaskRequest =
      zio.aws.iot.model.DescribeAuditMitigationActionsTaskRequest(taskId)
    def taskId: MitigationActionsTaskId
    def getTaskId: ZIO[Any, Nothing, MitigationActionsTaskId] =
      ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskRequest
  ) extends zio.aws.iot.model.DescribeAuditMitigationActionsTaskRequest.ReadOnly {
    override val taskId: MitigationActionsTaskId =
      zio.aws.iot.model.primitives.MitigationActionsTaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskRequest
  ): zio.aws.iot.model.DescribeAuditMitigationActionsTaskRequest.ReadOnly =
    new Wrapper(impl)
}
