package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  Timestamp,
  CustomMetricDisplayName,
  CustomMetricArn,
  MetricName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeCustomMetricResponse(
    metricName: Optional[MetricName] = Optional.Absent,
    metricArn: Optional[CustomMetricArn] = Optional.Absent,
    metricType: Optional[zio.aws.iot.model.CustomMetricType] = Optional.Absent,
    displayName: Optional[CustomMetricDisplayName] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    lastModifiedDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeCustomMetricResponse = {
    import DescribeCustomMetricResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeCustomMetricResponse
      .builder()
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        metricArn.map(value => CustomMetricArn.unwrap(value): java.lang.String)
      )(_.metricArn)
      .optionallyWith(metricType.map(value => value.unwrap))(_.metricType)
      .optionallyWith(
        displayName.map(value =>
          CustomMetricDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeCustomMetricResponse.ReadOnly =
    zio.aws.iot.model.DescribeCustomMetricResponse.wrap(buildAwsValue())
}
object DescribeCustomMetricResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeCustomMetricResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeCustomMetricResponse =
      zio.aws.iot.model.DescribeCustomMetricResponse(
        metricName.map(value => value),
        metricArn.map(value => value),
        metricType.map(value => value),
        displayName.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def metricName: Optional[MetricName]
    def metricArn: Optional[CustomMetricArn]
    def metricType: Optional[zio.aws.iot.model.CustomMetricType]
    def displayName: Optional[CustomMetricDisplayName]
    def creationDate: Optional[Timestamp]
    def lastModifiedDate: Optional[Timestamp]
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricArn: ZIO[Any, AwsError, CustomMetricArn] =
      AwsError.unwrapOptionField("metricArn", metricArn)
    def getMetricType: ZIO[Any, AwsError, zio.aws.iot.model.CustomMetricType] =
      AwsError.unwrapOptionField("metricType", metricType)
    def getDisplayName: ZIO[Any, AwsError, CustomMetricDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeCustomMetricResponse
  ) extends zio.aws.iot.model.DescribeCustomMetricResponse.ReadOnly {
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.iot.model.primitives.MetricName(value))
    override val metricArn: Optional[CustomMetricArn] = zio.aws.core.internal
      .optionalFromNullable(impl.metricArn())
      .map(value => zio.aws.iot.model.primitives.CustomMetricArn(value))
    override val metricType: Optional[zio.aws.iot.model.CustomMetricType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricType())
        .map(value => zio.aws.iot.model.CustomMetricType.wrap(value))
    override val displayName: Optional[CustomMetricDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.iot.model.primitives.CustomMetricDisplayName(value)
        )
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val lastModifiedDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeCustomMetricResponse
  ): zio.aws.iot.model.DescribeCustomMetricResponse.ReadOnly = new Wrapper(impl)
}
