package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  Timestamp,
  DimensionStringValue,
  DimensionArn,
  DimensionName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeDimensionResponse(
    name: Optional[DimensionName] = Optional.Absent,
    arn: Optional[DimensionArn] = Optional.Absent,
    `type`: Optional[zio.aws.iot.model.DimensionType] = Optional.Absent,
    stringValues: Optional[Iterable[DimensionStringValue]] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    lastModifiedDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeDimensionResponse = {
    import DescribeDimensionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeDimensionResponse
      .builder()
      .optionallyWith(
        name.map(value => DimensionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => DimensionArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        stringValues.map(value =>
          value.map { item =>
            DimensionStringValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stringValues)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeDimensionResponse.ReadOnly =
    zio.aws.iot.model.DescribeDimensionResponse.wrap(buildAwsValue())
}
object DescribeDimensionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeDimensionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeDimensionResponse =
      zio.aws.iot.model.DescribeDimensionResponse(
        name.map(value => value),
        arn.map(value => value),
        `type`.map(value => value),
        stringValues.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def name: Optional[DimensionName]
    def arn: Optional[DimensionArn]
    def `type`: Optional[zio.aws.iot.model.DimensionType]
    def stringValues: Optional[List[DimensionStringValue]]
    def creationDate: Optional[Timestamp]
    def lastModifiedDate: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, DimensionName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, DimensionArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.iot.model.DimensionType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStringValues: ZIO[Any, AwsError, List[DimensionStringValue]] =
      AwsError.unwrapOptionField("stringValues", stringValues)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeDimensionResponse
  ) extends zio.aws.iot.model.DescribeDimensionResponse.ReadOnly {
    override val name: Optional[DimensionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iot.model.primitives.DimensionName(value))
    override val arn: Optional[DimensionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iot.model.primitives.DimensionArn(value))
    override val `type`: Optional[zio.aws.iot.model.DimensionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.iot.model.DimensionType.wrap(value))
    override val stringValues: Optional[List[DimensionStringValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.DimensionStringValue(item)
          }.toList
        )
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val lastModifiedDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeDimensionResponse
  ): zio.aws.iot.model.DescribeDimensionResponse.ReadOnly = new Wrapper(impl)
}
