package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  JobTemplateArn,
  DateType,
  JobDocument,
  JobDocumentSource,
  JobDescription,
  JobTemplateId
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeJobTemplateResponse(
    jobTemplateArn: Optional[JobTemplateArn] = Optional.Absent,
    jobTemplateId: Optional[JobTemplateId] = Optional.Absent,
    description: Optional[JobDescription] = Optional.Absent,
    documentSource: Optional[JobDocumentSource] = Optional.Absent,
    document: Optional[JobDocument] = Optional.Absent,
    createdAt: Optional[DateType] = Optional.Absent,
    presignedUrlConfig: Optional[zio.aws.iot.model.PresignedUrlConfig] =
      Optional.Absent,
    jobExecutionsRolloutConfig: Optional[
      zio.aws.iot.model.JobExecutionsRolloutConfig
    ] = Optional.Absent,
    abortConfig: Optional[zio.aws.iot.model.AbortConfig] = Optional.Absent,
    timeoutConfig: Optional[zio.aws.iot.model.TimeoutConfig] = Optional.Absent,
    jobExecutionsRetryConfig: Optional[
      zio.aws.iot.model.JobExecutionsRetryConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse = {
    import DescribeJobTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse
      .builder()
      .optionallyWith(
        jobTemplateArn.map(value =>
          JobTemplateArn.unwrap(value): java.lang.String
        )
      )(_.jobTemplateArn)
      .optionallyWith(
        jobTemplateId.map(value =>
          JobTemplateId.unwrap(value): java.lang.String
        )
      )(_.jobTemplateId)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        documentSource.map(value =>
          JobDocumentSource.unwrap(value): java.lang.String
        )
      )(_.documentSource)
      .optionallyWith(
        document.map(value => JobDocument.unwrap(value): java.lang.String)
      )(_.document)
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(presignedUrlConfig.map(value => value.buildAwsValue()))(
        _.presignedUrlConfig
      )
      .optionallyWith(
        jobExecutionsRolloutConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRolloutConfig)
      .optionallyWith(abortConfig.map(value => value.buildAwsValue()))(
        _.abortConfig
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .optionallyWith(
        jobExecutionsRetryConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRetryConfig)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeJobTemplateResponse.ReadOnly =
    zio.aws.iot.model.DescribeJobTemplateResponse.wrap(buildAwsValue())
}
object DescribeJobTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeJobTemplateResponse =
      zio.aws.iot.model.DescribeJobTemplateResponse(
        jobTemplateArn.map(value => value),
        jobTemplateId.map(value => value),
        description.map(value => value),
        documentSource.map(value => value),
        document.map(value => value),
        createdAt.map(value => value),
        presignedUrlConfig.map(value => value.asEditable),
        jobExecutionsRolloutConfig.map(value => value.asEditable),
        abortConfig.map(value => value.asEditable),
        timeoutConfig.map(value => value.asEditable),
        jobExecutionsRetryConfig.map(value => value.asEditable)
      )
    def jobTemplateArn: Optional[JobTemplateArn]
    def jobTemplateId: Optional[JobTemplateId]
    def description: Optional[JobDescription]
    def documentSource: Optional[JobDocumentSource]
    def document: Optional[JobDocument]
    def createdAt: Optional[DateType]
    def presignedUrlConfig
        : Optional[zio.aws.iot.model.PresignedUrlConfig.ReadOnly]
    def jobExecutionsRolloutConfig
        : Optional[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly]
    def abortConfig: Optional[zio.aws.iot.model.AbortConfig.ReadOnly]
    def timeoutConfig: Optional[zio.aws.iot.model.TimeoutConfig.ReadOnly]
    def jobExecutionsRetryConfig
        : Optional[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly]
    def getJobTemplateArn: ZIO[Any, AwsError, JobTemplateArn] =
      AwsError.unwrapOptionField("jobTemplateArn", jobTemplateArn)
    def getJobTemplateId: ZIO[Any, AwsError, JobTemplateId] =
      AwsError.unwrapOptionField("jobTemplateId", jobTemplateId)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDocumentSource: ZIO[Any, AwsError, JobDocumentSource] =
      AwsError.unwrapOptionField("documentSource", documentSource)
    def getDocument: ZIO[Any, AwsError, JobDocument] =
      AwsError.unwrapOptionField("document", document)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getPresignedUrlConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      AwsError.unwrapOptionField("presignedUrlConfig", presignedUrlConfig)
    def getJobExecutionsRolloutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRolloutConfig",
      jobExecutionsRolloutConfig
    )
    def getAbortConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AbortConfig.ReadOnly] =
      AwsError.unwrapOptionField("abortConfig", abortConfig)
    def getTimeoutConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
    def getJobExecutionsRetryConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRetryConfig",
      jobExecutionsRetryConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse
  ) extends zio.aws.iot.model.DescribeJobTemplateResponse.ReadOnly {
    override val jobTemplateArn: Optional[JobTemplateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTemplateArn())
        .map(value => zio.aws.iot.model.primitives.JobTemplateArn(value))
    override val jobTemplateId: Optional[JobTemplateId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTemplateId())
      .map(value => zio.aws.iot.model.primitives.JobTemplateId(value))
    override val description: Optional[JobDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val documentSource: Optional[JobDocumentSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentSource())
        .map(value => zio.aws.iot.model.primitives.JobDocumentSource(value))
    override val document: Optional[JobDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.document())
      .map(value => zio.aws.iot.model.primitives.JobDocument(value))
    override val createdAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val presignedUrlConfig
        : Optional[zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.presignedUrlConfig())
        .map(value => zio.aws.iot.model.PresignedUrlConfig.wrap(value))
    override val jobExecutionsRolloutConfig
        : Optional[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionsRolloutConfig())
        .map(value => zio.aws.iot.model.JobExecutionsRolloutConfig.wrap(value))
    override val abortConfig: Optional[zio.aws.iot.model.AbortConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.abortConfig())
        .map(value => zio.aws.iot.model.AbortConfig.wrap(value))
    override val timeoutConfig
        : Optional[zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutConfig())
        .map(value => zio.aws.iot.model.TimeoutConfig.wrap(value))
    override val jobExecutionsRetryConfig
        : Optional[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionsRetryConfig())
        .map(value => zio.aws.iot.model.JobExecutionsRetryConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse
  ): zio.aws.iot.model.DescribeJobTemplateResponse.ReadOnly = new Wrapper(impl)
}
