package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RoleArn,
  MitigationActionArn,
  MitigationActionId,
  Timestamp,
  MitigationActionName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeMitigationActionResponse(
    actionName: Optional[MitigationActionName] = Optional.Absent,
    actionType: Optional[zio.aws.iot.model.MitigationActionType] =
      Optional.Absent,
    actionArn: Optional[MitigationActionArn] = Optional.Absent,
    actionId: Optional[MitigationActionId] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    actionParams: Optional[zio.aws.iot.model.MitigationActionParams] =
      Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    lastModifiedDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse = {
    import DescribeMitigationActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse
      .builder()
      .optionallyWith(
        actionName.map(value =>
          MitigationActionName.unwrap(value): java.lang.String
        )
      )(_.actionName)
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(
        actionArn.map(value =>
          MitigationActionArn.unwrap(value): java.lang.String
        )
      )(_.actionArn)
      .optionallyWith(
        actionId.map(value =>
          MitigationActionId.unwrap(value): java.lang.String
        )
      )(_.actionId)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(actionParams.map(value => value.buildAwsValue()))(
        _.actionParams
      )
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeMitigationActionResponse.ReadOnly =
    zio.aws.iot.model.DescribeMitigationActionResponse.wrap(buildAwsValue())
}
object DescribeMitigationActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeMitigationActionResponse =
      zio.aws.iot.model.DescribeMitigationActionResponse(
        actionName.map(value => value),
        actionType.map(value => value),
        actionArn.map(value => value),
        actionId.map(value => value),
        roleArn.map(value => value),
        actionParams.map(value => value.asEditable),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def actionName: Optional[MitigationActionName]
    def actionType: Optional[zio.aws.iot.model.MitigationActionType]
    def actionArn: Optional[MitigationActionArn]
    def actionId: Optional[MitigationActionId]
    def roleArn: Optional[RoleArn]
    def actionParams
        : Optional[zio.aws.iot.model.MitigationActionParams.ReadOnly]
    def creationDate: Optional[Timestamp]
    def lastModifiedDate: Optional[Timestamp]
    def getActionName: ZIO[Any, AwsError, MitigationActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getActionType
        : ZIO[Any, AwsError, zio.aws.iot.model.MitigationActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getActionArn: ZIO[Any, AwsError, MitigationActionArn] =
      AwsError.unwrapOptionField("actionArn", actionArn)
    def getActionId: ZIO[Any, AwsError, MitigationActionId] =
      AwsError.unwrapOptionField("actionId", actionId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getActionParams: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.MitigationActionParams.ReadOnly
    ] = AwsError.unwrapOptionField("actionParams", actionParams)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse
  ) extends zio.aws.iot.model.DescribeMitigationActionResponse.ReadOnly {
    override val actionName: Optional[MitigationActionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionName())
        .map(value => zio.aws.iot.model.primitives.MitigationActionName(value))
    override val actionType: Optional[zio.aws.iot.model.MitigationActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionType())
        .map(value => zio.aws.iot.model.MitigationActionType.wrap(value))
    override val actionArn: Optional[MitigationActionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionArn())
        .map(value => zio.aws.iot.model.primitives.MitigationActionArn(value))
    override val actionId: Optional[MitigationActionId] = zio.aws.core.internal
      .optionalFromNullable(impl.actionId())
      .map(value => zio.aws.iot.model.primitives.MitigationActionId(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val actionParams
        : Optional[zio.aws.iot.model.MitigationActionParams.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionParams())
        .map(value => zio.aws.iot.model.MitigationActionParams.wrap(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val lastModifiedDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse
  ): zio.aws.iot.model.DescribeMitigationActionResponse.ReadOnly = new Wrapper(
    impl
  )
}
