package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.TemplateName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeProvisioningTemplateRequest(
    templateName: TemplateName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateRequest = {
    import DescribeProvisioningTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeProvisioningTemplateRequest.ReadOnly =
    zio.aws.iot.model.DescribeProvisioningTemplateRequest.wrap(buildAwsValue())
}
object DescribeProvisioningTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeProvisioningTemplateRequest =
      zio.aws.iot.model.DescribeProvisioningTemplateRequest(templateName)
    def templateName: TemplateName
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateRequest
  ) extends zio.aws.iot.model.DescribeProvisioningTemplateRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.iot.model.primitives.TemplateName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateRequest
  ): zio.aws.iot.model.DescribeProvisioningTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
