package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RoleArn,
  TemplateArn,
  DateType,
  TemplateName,
  TemplateDescription,
  TemplateVersionId,
  Enabled,
  TemplateBody
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeProvisioningTemplateResponse(
    templateArn: Optional[TemplateArn] = Optional.Absent,
    templateName: Optional[TemplateName] = Optional.Absent,
    description: Optional[TemplateDescription] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    defaultVersionId: Optional[TemplateVersionId] = Optional.Absent,
    templateBody: Optional[TemplateBody] = Optional.Absent,
    enabled: Optional[Enabled] = Optional.Absent,
    provisioningRoleArn: Optional[RoleArn] = Optional.Absent,
    preProvisioningHook: Optional[zio.aws.iot.model.ProvisioningHook] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateResponse = {
    import DescribeProvisioningTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateResponse
      .builder()
      .optionallyWith(
        templateArn.map(value => TemplateArn.unwrap(value): java.lang.String)
      )(_.templateArn)
      .optionallyWith(
        templateName.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.templateName)
      .optionallyWith(
        description.map(value =>
          TemplateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        defaultVersionId.map(value => TemplateVersionId.unwrap(value): Integer)
      )(_.defaultVersionId)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        provisioningRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.provisioningRoleArn)
      .optionallyWith(preProvisioningHook.map(value => value.buildAwsValue()))(
        _.preProvisioningHook
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeProvisioningTemplateResponse.ReadOnly =
    zio.aws.iot.model.DescribeProvisioningTemplateResponse.wrap(buildAwsValue())
}
object DescribeProvisioningTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeProvisioningTemplateResponse =
      zio.aws.iot.model.DescribeProvisioningTemplateResponse(
        templateArn.map(value => value),
        templateName.map(value => value),
        description.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        defaultVersionId.map(value => value),
        templateBody.map(value => value),
        enabled.map(value => value),
        provisioningRoleArn.map(value => value),
        preProvisioningHook.map(value => value.asEditable)
      )
    def templateArn: Optional[TemplateArn]
    def templateName: Optional[TemplateName]
    def description: Optional[TemplateDescription]
    def creationDate: Optional[DateType]
    def lastModifiedDate: Optional[DateType]
    def defaultVersionId: Optional[TemplateVersionId]
    def templateBody: Optional[TemplateBody]
    def enabled: Optional[Enabled]
    def provisioningRoleArn: Optional[RoleArn]
    def preProvisioningHook
        : Optional[zio.aws.iot.model.ProvisioningHook.ReadOnly]
    def getTemplateArn: ZIO[Any, AwsError, TemplateArn] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getTemplateName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getDescription: ZIO[Any, AwsError, TemplateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getDefaultVersionId: ZIO[Any, AwsError, TemplateVersionId] =
      AwsError.unwrapOptionField("defaultVersionId", defaultVersionId)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getProvisioningRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("provisioningRoleArn", provisioningRoleArn)
    def getPreProvisioningHook
        : ZIO[Any, AwsError, zio.aws.iot.model.ProvisioningHook.ReadOnly] =
      AwsError.unwrapOptionField("preProvisioningHook", preProvisioningHook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateResponse
  ) extends zio.aws.iot.model.DescribeProvisioningTemplateResponse.ReadOnly {
    override val templateArn: Optional[TemplateArn] = zio.aws.core.internal
      .optionalFromNullable(impl.templateArn())
      .map(value => zio.aws.iot.model.primitives.TemplateArn(value))
    override val templateName: Optional[TemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.templateName())
      .map(value => zio.aws.iot.model.primitives.TemplateName(value))
    override val description: Optional[TemplateDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.iot.model.primitives.TemplateDescription(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val defaultVersionId: Optional[TemplateVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultVersionId())
        .map(value => zio.aws.iot.model.primitives.TemplateVersionId(value))
    override val templateBody: Optional[TemplateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.iot.model.primitives.TemplateBody(value))
    override val enabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.iot.model.primitives.Enabled(value))
    override val provisioningRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningRoleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val preProvisioningHook
        : Optional[zio.aws.iot.model.ProvisioningHook.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preProvisioningHook())
        .map(value => zio.aws.iot.model.ProvisioningHook.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateResponse
  ): zio.aws.iot.model.DescribeProvisioningTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
