package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  IsDefaultVersion,
  TemplateBody,
  DateType,
  TemplateVersionId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeProvisioningTemplateVersionResponse(
    versionId: Optional[TemplateVersionId] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    templateBody: Optional[TemplateBody] = Optional.Absent,
    isDefaultVersion: Optional[IsDefaultVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse = {
    import DescribeProvisioningTemplateVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse
      .builder()
      .optionallyWith(
        versionId.map(value => TemplateVersionId.unwrap(value): Integer)
      )(_.versionId)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse.ReadOnly =
    zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse
      .wrap(buildAwsValue())
}
object DescribeProvisioningTemplateVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse =
      zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse(
        versionId.map(value => value),
        creationDate.map(value => value),
        templateBody.map(value => value),
        isDefaultVersion.map(value => value)
      )
    def versionId: Optional[TemplateVersionId]
    def creationDate: Optional[DateType]
    def templateBody: Optional[TemplateBody]
    def isDefaultVersion: Optional[IsDefaultVersion]
    def getVersionId: ZIO[Any, AwsError, TemplateVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse
  ) extends zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse.ReadOnly {
    override val versionId: Optional[TemplateVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.iot.model.primitives.TemplateVersionId(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val templateBody: Optional[TemplateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.iot.model.primitives.TemplateBody(value))
    override val isDefaultVersion: Optional[IsDefaultVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isDefaultVersion())
        .map(value => zio.aws.iot.model.primitives.IsDefaultVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse
  ): zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse.ReadOnly =
    new Wrapper(impl)
}
