package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingTypeName,
  AttributeName,
  ThingName,
  ThingArn,
  ClientId,
  BillingGroupName,
  Version,
  ThingId,
  AttributeValue
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeThingResponse(
    defaultClientId: Optional[ClientId] = Optional.Absent,
    thingName: Optional[ThingName] = Optional.Absent,
    thingId: Optional[ThingId] = Optional.Absent,
    thingArn: Optional[ThingArn] = Optional.Absent,
    thingTypeName: Optional[ThingTypeName] = Optional.Absent,
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    version: Optional[Version] = Optional.Absent,
    billingGroupName: Optional[BillingGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeThingResponse = {
    import DescribeThingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeThingResponse
      .builder()
      .optionallyWith(
        defaultClientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.defaultClientId)
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        thingId.map(value => ThingId.unwrap(value): java.lang.String)
      )(_.thingId)
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        billingGroupName.map(value =>
          BillingGroupName.unwrap(value): java.lang.String
        )
      )(_.billingGroupName)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeThingResponse.ReadOnly =
    zio.aws.iot.model.DescribeThingResponse.wrap(buildAwsValue())
}
object DescribeThingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeThingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeThingResponse =
      zio.aws.iot.model.DescribeThingResponse(
        defaultClientId.map(value => value),
        thingName.map(value => value),
        thingId.map(value => value),
        thingArn.map(value => value),
        thingTypeName.map(value => value),
        attributes.map(value => value),
        version.map(value => value),
        billingGroupName.map(value => value)
      )
    def defaultClientId: Optional[ClientId]
    def thingName: Optional[ThingName]
    def thingId: Optional[ThingId]
    def thingArn: Optional[ThingArn]
    def thingTypeName: Optional[ThingTypeName]
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def version: Optional[Version]
    def billingGroupName: Optional[BillingGroupName]
    def getDefaultClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("defaultClientId", defaultClientId)
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getThingId: ZIO[Any, AwsError, ThingId] =
      AwsError.unwrapOptionField("thingId", thingId)
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getBillingGroupName: ZIO[Any, AwsError, BillingGroupName] =
      AwsError.unwrapOptionField("billingGroupName", billingGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingResponse
  ) extends zio.aws.iot.model.DescribeThingResponse.ReadOnly {
    override val defaultClientId: Optional[ClientId] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultClientId())
      .map(value => zio.aws.iot.model.primitives.ClientId(value))
    override val thingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.ThingName(value))
    override val thingId: Optional[ThingId] = zio.aws.core.internal
      .optionalFromNullable(impl.thingId())
      .map(value => zio.aws.iot.model.primitives.ThingId(value))
    override val thingArn: Optional[ThingArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingArn())
      .map(value => zio.aws.iot.model.primitives.ThingArn(value))
    override val thingTypeName: Optional[ThingTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives.AttributeName(
                key
              ) -> zio.aws.iot.model.primitives.AttributeValue(value)
            })
            .toMap
        )
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.iot.model.primitives.Version(value))
    override val billingGroupName: Optional[BillingGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupName())
        .map(value => zio.aws.iot.model.primitives.BillingGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingResponse
  ): zio.aws.iot.model.DescribeThingResponse.ReadOnly = new Wrapper(impl)
}
