package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{ThingTypeArn, ThingTypeId, ThingTypeName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeThingTypeResponse(
    thingTypeName: Optional[ThingTypeName] = Optional.Absent,
    thingTypeId: Optional[ThingTypeId] = Optional.Absent,
    thingTypeArn: Optional[ThingTypeArn] = Optional.Absent,
    thingTypeProperties: Optional[zio.aws.iot.model.ThingTypeProperties] =
      Optional.Absent,
    thingTypeMetadata: Optional[zio.aws.iot.model.ThingTypeMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeThingTypeResponse = {
    import DescribeThingTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeThingTypeResponse
      .builder()
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .optionallyWith(
        thingTypeId.map(value => ThingTypeId.unwrap(value): java.lang.String)
      )(_.thingTypeId)
      .optionallyWith(
        thingTypeArn.map(value => ThingTypeArn.unwrap(value): java.lang.String)
      )(_.thingTypeArn)
      .optionallyWith(thingTypeProperties.map(value => value.buildAwsValue()))(
        _.thingTypeProperties
      )
      .optionallyWith(thingTypeMetadata.map(value => value.buildAwsValue()))(
        _.thingTypeMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeThingTypeResponse.ReadOnly =
    zio.aws.iot.model.DescribeThingTypeResponse.wrap(buildAwsValue())
}
object DescribeThingTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeThingTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeThingTypeResponse =
      zio.aws.iot.model.DescribeThingTypeResponse(
        thingTypeName.map(value => value),
        thingTypeId.map(value => value),
        thingTypeArn.map(value => value),
        thingTypeProperties.map(value => value.asEditable),
        thingTypeMetadata.map(value => value.asEditable)
      )
    def thingTypeName: Optional[ThingTypeName]
    def thingTypeId: Optional[ThingTypeId]
    def thingTypeArn: Optional[ThingTypeArn]
    def thingTypeProperties
        : Optional[zio.aws.iot.model.ThingTypeProperties.ReadOnly]
    def thingTypeMetadata
        : Optional[zio.aws.iot.model.ThingTypeMetadata.ReadOnly]
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
    def getThingTypeId: ZIO[Any, AwsError, ThingTypeId] =
      AwsError.unwrapOptionField("thingTypeId", thingTypeId)
    def getThingTypeArn: ZIO[Any, AwsError, ThingTypeArn] =
      AwsError.unwrapOptionField("thingTypeArn", thingTypeArn)
    def getThingTypeProperties
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingTypeProperties.ReadOnly] =
      AwsError.unwrapOptionField("thingTypeProperties", thingTypeProperties)
    def getThingTypeMetadata
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingTypeMetadata.ReadOnly] =
      AwsError.unwrapOptionField("thingTypeMetadata", thingTypeMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingTypeResponse
  ) extends zio.aws.iot.model.DescribeThingTypeResponse.ReadOnly {
    override val thingTypeName: Optional[ThingTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
    override val thingTypeId: Optional[ThingTypeId] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeId())
      .map(value => zio.aws.iot.model.primitives.ThingTypeId(value))
    override val thingTypeArn: Optional[ThingTypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeArn())
      .map(value => zio.aws.iot.model.primitives.ThingTypeArn(value))
    override val thingTypeProperties
        : Optional[zio.aws.iot.model.ThingTypeProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingTypeProperties())
        .map(value => zio.aws.iot.model.ThingTypeProperties.wrap(value))
    override val thingTypeMetadata
        : Optional[zio.aws.iot.model.ThingTypeMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingTypeMetadata())
        .map(value => zio.aws.iot.model.ThingTypeMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingTypeResponse
  ): zio.aws.iot.model.DescribeThingTypeResponse.ReadOnly = new Wrapper(impl)
}
