package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DeviceDefenderThingName,
  ErrorMessage,
  ViolationId,
  Timestamp,
  DetectMitigationActionExecutionErrorCode,
  MitigationActionsTaskId,
  MitigationActionName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DetectMitigationActionExecution(
    taskId: Optional[MitigationActionsTaskId] = Optional.Absent,
    violationId: Optional[ViolationId] = Optional.Absent,
    actionName: Optional[MitigationActionName] = Optional.Absent,
    thingName: Optional[DeviceDefenderThingName] = Optional.Absent,
    executionStartDate: Optional[Timestamp] = Optional.Absent,
    executionEndDate: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.iot.model.DetectMitigationActionExecutionStatus] =
      Optional.Absent,
    errorCode: Optional[DetectMitigationActionExecutionErrorCode] =
      Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DetectMitigationActionExecution = {
    import DetectMitigationActionExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DetectMitigationActionExecution
      .builder()
      .optionallyWith(
        taskId.map(value =>
          MitigationActionsTaskId.unwrap(value): java.lang.String
        )
      )(_.taskId)
      .optionallyWith(
        violationId.map(value => ViolationId.unwrap(value): java.lang.String)
      )(_.violationId)
      .optionallyWith(
        actionName.map(value =>
          MitigationActionName.unwrap(value): java.lang.String
        )
      )(_.actionName)
      .optionallyWith(
        thingName.map(value =>
          DeviceDefenderThingName.unwrap(value): java.lang.String
        )
      )(_.thingName)
      .optionallyWith(
        executionStartDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.executionStartDate)
      .optionallyWith(
        executionEndDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.executionEndDate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        errorCode.map(value =>
          DetectMitigationActionExecutionErrorCode.unwrap(
            value
          ): java.lang.String
        )
      )(_.errorCode)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly =
    zio.aws.iot.model.DetectMitigationActionExecution.wrap(buildAwsValue())
}
object DetectMitigationActionExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DetectMitigationActionExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DetectMitigationActionExecution =
      zio.aws.iot.model.DetectMitigationActionExecution(
        taskId.map(value => value),
        violationId.map(value => value),
        actionName.map(value => value),
        thingName.map(value => value),
        executionStartDate.map(value => value),
        executionEndDate.map(value => value),
        status.map(value => value),
        errorCode.map(value => value),
        message.map(value => value)
      )
    def taskId: Optional[MitigationActionsTaskId]
    def violationId: Optional[ViolationId]
    def actionName: Optional[MitigationActionName]
    def thingName: Optional[DeviceDefenderThingName]
    def executionStartDate: Optional[Timestamp]
    def executionEndDate: Optional[Timestamp]
    def status
        : Optional[zio.aws.iot.model.DetectMitigationActionExecutionStatus]
    def errorCode: Optional[DetectMitigationActionExecutionErrorCode]
    def message: Optional[ErrorMessage]
    def getTaskId: ZIO[Any, AwsError, MitigationActionsTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getViolationId: ZIO[Any, AwsError, ViolationId] =
      AwsError.unwrapOptionField("violationId", violationId)
    def getActionName: ZIO[Any, AwsError, MitigationActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getThingName: ZIO[Any, AwsError, DeviceDefenderThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getExecutionStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("executionStartDate", executionStartDate)
    def getExecutionEndDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("executionEndDate", executionEndDate)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.DetectMitigationActionExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getErrorCode
        : ZIO[Any, AwsError, DetectMitigationActionExecutionErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DetectMitigationActionExecution
  ) extends zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly {
    override val taskId: Optional[MitigationActionsTaskId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskId())
        .map(value =>
          zio.aws.iot.model.primitives.MitigationActionsTaskId(value)
        )
    override val violationId: Optional[ViolationId] = zio.aws.core.internal
      .optionalFromNullable(impl.violationId())
      .map(value => zio.aws.iot.model.primitives.ViolationId(value))
    override val actionName: Optional[MitigationActionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionName())
        .map(value => zio.aws.iot.model.primitives.MitigationActionName(value))
    override val thingName: Optional[DeviceDefenderThingName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingName())
        .map(value =>
          zio.aws.iot.model.primitives.DeviceDefenderThingName(value)
        )
    override val executionStartDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.executionStartDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val executionEndDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.executionEndDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val status
        : Optional[zio.aws.iot.model.DetectMitigationActionExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.iot.model.DetectMitigationActionExecutionStatus.wrap(value)
        )
    override val errorCode: Optional[DetectMitigationActionExecutionErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value =>
          zio.aws.iot.model.primitives
            .DetectMitigationActionExecutionErrorCode(value)
        )
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.iot.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DetectMitigationActionExecution
  ): zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly = new Wrapper(
    impl
  )
}
