package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.GenericLongValue
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DetectMitigationActionsTaskStatistics(
    actionsExecuted: Optional[GenericLongValue] = Optional.Absent,
    actionsSkipped: Optional[GenericLongValue] = Optional.Absent,
    actionsFailed: Optional[GenericLongValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatistics = {
    import DetectMitigationActionsTaskStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatistics
      .builder()
      .optionallyWith(
        actionsExecuted.map(value =>
          GenericLongValue.unwrap(value): java.lang.Long
        )
      )(_.actionsExecuted)
      .optionallyWith(
        actionsSkipped.map(value =>
          GenericLongValue.unwrap(value): java.lang.Long
        )
      )(_.actionsSkipped)
      .optionallyWith(
        actionsFailed.map(value =>
          GenericLongValue.unwrap(value): java.lang.Long
        )
      )(_.actionsFailed)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DetectMitigationActionsTaskStatistics.ReadOnly =
    zio.aws.iot.model.DetectMitigationActionsTaskStatistics
      .wrap(buildAwsValue())
}
object DetectMitigationActionsTaskStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DetectMitigationActionsTaskStatistics =
      zio.aws.iot.model.DetectMitigationActionsTaskStatistics(
        actionsExecuted.map(value => value),
        actionsSkipped.map(value => value),
        actionsFailed.map(value => value)
      )
    def actionsExecuted: Optional[GenericLongValue]
    def actionsSkipped: Optional[GenericLongValue]
    def actionsFailed: Optional[GenericLongValue]
    def getActionsExecuted: ZIO[Any, AwsError, GenericLongValue] =
      AwsError.unwrapOptionField("actionsExecuted", actionsExecuted)
    def getActionsSkipped: ZIO[Any, AwsError, GenericLongValue] =
      AwsError.unwrapOptionField("actionsSkipped", actionsSkipped)
    def getActionsFailed: ZIO[Any, AwsError, GenericLongValue] =
      AwsError.unwrapOptionField("actionsFailed", actionsFailed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatistics
  ) extends zio.aws.iot.model.DetectMitigationActionsTaskStatistics.ReadOnly {
    override val actionsExecuted: Optional[GenericLongValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsExecuted())
        .map(value => zio.aws.iot.model.primitives.GenericLongValue(value))
    override val actionsSkipped: Optional[GenericLongValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsSkipped())
        .map(value => zio.aws.iot.model.primitives.GenericLongValue(value))
    override val actionsFailed: Optional[GenericLongValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsFailed())
        .map(value => zio.aws.iot.model.primitives.GenericLongValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatistics
  ): zio.aws.iot.model.DetectMitigationActionsTaskStatistics.ReadOnly =
    new Wrapper(impl)
}
