package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait DimensionType {
  def unwrap: software.amazon.awssdk.services.iot.model.DimensionType
}
object DimensionType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.DimensionType
  ): zio.aws.iot.model.DimensionType = value match {
    case software.amazon.awssdk.services.iot.model.DimensionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.DimensionType.TOPIC_FILTER =>
      val r = TOPIC_FILTER
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.DimensionType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DimensionType =
      software.amazon.awssdk.services.iot.model.DimensionType.UNKNOWN_TO_SDK_VERSION
  }
  case object TOPIC_FILTER extends zio.aws.iot.model.DimensionType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DimensionType =
      software.amazon.awssdk.services.iot.model.DimensionType.TOPIC_FILTER
  }
}
