package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.RuleName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EnableTopicRuleRequest(ruleName: RuleName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest = {
    import EnableTopicRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest
      .builder()
      .ruleName(RuleName.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.EnableTopicRuleRequest.ReadOnly =
    zio.aws.iot.model.EnableTopicRuleRequest.wrap(buildAwsValue())
}
object EnableTopicRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.EnableTopicRuleRequest =
      zio.aws.iot.model.EnableTopicRuleRequest(ruleName)
    def ruleName: RuleName
    def getRuleName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest
  ) extends zio.aws.iot.model.EnableTopicRuleRequest.ReadOnly {
    override val ruleName: RuleName =
      zio.aws.iot.model.primitives.RuleName(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest
  ): zio.aws.iot.model.EnableTopicRuleRequest.ReadOnly = new Wrapper(impl)
}
