package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  QueryVersion,
  AggregationField,
  QueryString,
  IndexName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCardinalityRequest(
    indexName: Optional[IndexName] = Optional.Absent,
    queryString: QueryString,
    aggregationField: Optional[AggregationField] = Optional.Absent,
    queryVersion: Optional[QueryVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetCardinalityRequest = {
    import GetCardinalityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetCardinalityRequest
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        aggregationField.map(value =>
          AggregationField.unwrap(value): java.lang.String
        )
      )(_.aggregationField)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetCardinalityRequest.ReadOnly =
    zio.aws.iot.model.GetCardinalityRequest.wrap(buildAwsValue())
}
object GetCardinalityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetCardinalityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetCardinalityRequest =
      zio.aws.iot.model.GetCardinalityRequest(
        indexName.map(value => value),
        queryString,
        aggregationField.map(value => value),
        queryVersion.map(value => value)
      )
    def indexName: Optional[IndexName]
    def queryString: QueryString
    def aggregationField: Optional[AggregationField]
    def queryVersion: Optional[QueryVersion]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getAggregationField: ZIO[Any, AwsError, AggregationField] =
      AwsError.unwrapOptionField("aggregationField", aggregationField)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetCardinalityRequest
  ) extends zio.aws.iot.model.GetCardinalityRequest.ReadOnly {
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val queryString: QueryString =
      zio.aws.iot.model.primitives.QueryString(impl.queryString())
    override val aggregationField: Optional[AggregationField] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationField())
        .map(value => zio.aws.iot.model.primitives.AggregationField(value))
    override val queryVersion: Optional[QueryVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetCardinalityRequest
  ): zio.aws.iot.model.GetCardinalityRequest.ReadOnly = new Wrapper(impl)
}
