package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetOtaUpdateResponse(
    otaUpdateInfo: Optional[zio.aws.iot.model.OTAUpdateInfo] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetOtaUpdateResponse = {
    import GetOtaUpdateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetOtaUpdateResponse
      .builder()
      .optionallyWith(otaUpdateInfo.map(value => value.buildAwsValue()))(
        _.otaUpdateInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetOtaUpdateResponse.ReadOnly =
    zio.aws.iot.model.GetOtaUpdateResponse.wrap(buildAwsValue())
}
object GetOtaUpdateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetOtaUpdateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetOtaUpdateResponse = zio.aws.iot.model
      .GetOtaUpdateResponse(otaUpdateInfo.map(value => value.asEditable))
    def otaUpdateInfo: Optional[zio.aws.iot.model.OTAUpdateInfo.ReadOnly]
    def getOtaUpdateInfo
        : ZIO[Any, AwsError, zio.aws.iot.model.OTAUpdateInfo.ReadOnly] =
      AwsError.unwrapOptionField("otaUpdateInfo", otaUpdateInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetOtaUpdateResponse
  ) extends zio.aws.iot.model.GetOtaUpdateResponse.ReadOnly {
    override val otaUpdateInfo
        : Optional[zio.aws.iot.model.OTAUpdateInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.otaUpdateInfo())
        .map(value => zio.aws.iot.model.OTAUpdateInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetOtaUpdateResponse
  ): zio.aws.iot.model.GetOtaUpdateResponse.ReadOnly = new Wrapper(impl)
}
