package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PolicyVersionId, PolicyName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetPolicyVersionRequest(
    policyName: PolicyName,
    policyVersionId: PolicyVersionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest = {
    import GetPolicyVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .policyVersionId(
        PolicyVersionId.unwrap(policyVersionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetPolicyVersionRequest.ReadOnly =
    zio.aws.iot.model.GetPolicyVersionRequest.wrap(buildAwsValue())
}
object GetPolicyVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetPolicyVersionRequest =
      zio.aws.iot.model.GetPolicyVersionRequest(policyName, policyVersionId)
    def policyName: PolicyName
    def policyVersionId: PolicyVersionId
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getPolicyVersionId: ZIO[Any, Nothing, PolicyVersionId] =
      ZIO.succeed(policyVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest
  ) extends zio.aws.iot.model.GetPolicyVersionRequest.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.iot.model.primitives.PolicyName(impl.policyName())
    override val policyVersionId: PolicyVersionId =
      zio.aws.iot.model.primitives.PolicyVersionId(impl.policyVersionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest
  ): zio.aws.iot.model.GetPolicyVersionRequest.ReadOnly = new Wrapper(impl)
}
