package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.RegistrationCode
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRegistrationCodeResponse(
    registrationCode: Optional[RegistrationCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetRegistrationCodeResponse = {
    import GetRegistrationCodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetRegistrationCodeResponse
      .builder()
      .optionallyWith(
        registrationCode.map(value =>
          RegistrationCode.unwrap(value): java.lang.String
        )
      )(_.registrationCode)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetRegistrationCodeResponse.ReadOnly =
    zio.aws.iot.model.GetRegistrationCodeResponse.wrap(buildAwsValue())
}
object GetRegistrationCodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetRegistrationCodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetRegistrationCodeResponse =
      zio.aws.iot.model
        .GetRegistrationCodeResponse(registrationCode.map(value => value))
    def registrationCode: Optional[RegistrationCode]
    def getRegistrationCode: ZIO[Any, AwsError, RegistrationCode] =
      AwsError.unwrapOptionField("registrationCode", registrationCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetRegistrationCodeResponse
  ) extends zio.aws.iot.model.GetRegistrationCodeResponse.ReadOnly {
    override val registrationCode: Optional[RegistrationCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationCode())
        .map(value => zio.aws.iot.model.primitives.RegistrationCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetRegistrationCodeResponse
  ): zio.aws.iot.model.GetRegistrationCodeResponse.ReadOnly = new Wrapper(impl)
}
