package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{HeaderValue, HeaderKey}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class HttpActionHeader(key: HeaderKey, value: HeaderValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.HttpActionHeader = {
    import HttpActionHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.HttpActionHeader
      .builder()
      .key(HeaderKey.unwrap(key): java.lang.String)
      .value(HeaderValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.HttpActionHeader.ReadOnly =
    zio.aws.iot.model.HttpActionHeader.wrap(buildAwsValue())
}
object HttpActionHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.HttpActionHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.HttpActionHeader =
      zio.aws.iot.model.HttpActionHeader(key, value)
    def key: HeaderKey
    def value: HeaderValue
    def getKey: ZIO[Any, Nothing, HeaderKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, HeaderValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.HttpActionHeader
  ) extends zio.aws.iot.model.HttpActionHeader.ReadOnly {
    override val key: HeaderKey =
      zio.aws.iot.model.primitives.HeaderKey(impl.key())
    override val value: HeaderValue =
      zio.aws.iot.model.primitives.HeaderValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.HttpActionHeader
  ): zio.aws.iot.model.HttpActionHeader.ReadOnly = new Wrapper(impl)
}
