package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  HttpQueryString,
  HttpHeaderValue,
  HttpHeaderName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HttpContext(
    headers: Optional[Map[HttpHeaderName, HttpHeaderValue]] = Optional.Absent,
    queryString: Optional[HttpQueryString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.HttpContext = {
    import HttpContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.HttpContext
      .builder()
      .optionallyWith(
        headers.map(value =>
          value
            .map({ case (key, value) =>
              (HttpHeaderName.unwrap(key): java.lang.String) -> (HttpHeaderValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.headers)
      .optionallyWith(
        queryString.map(value =>
          HttpQueryString.unwrap(value): java.lang.String
        )
      )(_.queryString)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.HttpContext.ReadOnly =
    zio.aws.iot.model.HttpContext.wrap(buildAwsValue())
}
object HttpContext {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.HttpContext] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.HttpContext = zio.aws.iot.model
      .HttpContext(headers.map(value => value), queryString.map(value => value))
    def headers: Optional[Map[HttpHeaderName, HttpHeaderValue]]
    def queryString: Optional[HttpQueryString]
    def getHeaders: ZIO[Any, AwsError, Map[HttpHeaderName, HttpHeaderValue]] =
      AwsError.unwrapOptionField("headers", headers)
    def getQueryString: ZIO[Any, AwsError, HttpQueryString] =
      AwsError.unwrapOptionField("queryString", queryString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.HttpContext
  ) extends zio.aws.iot.model.HttpContext.ReadOnly {
    override val headers: Optional[Map[HttpHeaderName, HttpHeaderValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.headers())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives.HttpHeaderName(
                key
              ) -> zio.aws.iot.model.primitives.HttpHeaderValue(value)
            })
            .toMap
        )
    override val queryString: Optional[HttpQueryString] = zio.aws.core.internal
      .optionalFromNullable(impl.queryString())
      .map(value => zio.aws.iot.model.primitives.HttpQueryString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.HttpContext
  ): zio.aws.iot.model.HttpContext.ReadOnly = new Wrapper(impl)
}
