package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class IotSiteWiseAction(
    putAssetPropertyValueEntries: Iterable[
      zio.aws.iot.model.PutAssetPropertyValueEntry
    ],
    roleArn: AwsArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.IotSiteWiseAction = {
    import IotSiteWiseAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.IotSiteWiseAction
      .builder()
      .putAssetPropertyValueEntries(putAssetPropertyValueEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.IotSiteWiseAction.ReadOnly =
    zio.aws.iot.model.IotSiteWiseAction.wrap(buildAwsValue())
}
object IotSiteWiseAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.IotSiteWiseAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.IotSiteWiseAction =
      zio.aws.iot.model.IotSiteWiseAction(
        putAssetPropertyValueEntries.map { item =>
          item.asEditable
        },
        roleArn
      )
    def putAssetPropertyValueEntries
        : List[zio.aws.iot.model.PutAssetPropertyValueEntry.ReadOnly]
    def roleArn: AwsArn
    def getPutAssetPropertyValueEntries: ZIO[Any, Nothing, List[
      zio.aws.iot.model.PutAssetPropertyValueEntry.ReadOnly
    ]] = ZIO.succeed(putAssetPropertyValueEntries)
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.IotSiteWiseAction
  ) extends zio.aws.iot.model.IotSiteWiseAction.ReadOnly {
    override val putAssetPropertyValueEntries
        : List[zio.aws.iot.model.PutAssetPropertyValueEntry.ReadOnly] = impl
      .putAssetPropertyValueEntries()
      .asScala
      .map { item =>
        zio.aws.iot.model.PutAssetPropertyValueEntry.wrap(item)
      }
      .toList
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.IotSiteWiseAction
  ): zio.aws.iot.model.IotSiteWiseAction.ReadOnly = new Wrapper(impl)
}
