package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.JobId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class JobExecutionSummaryForThing(
    jobId: Optional[JobId] = Optional.Absent,
    jobExecutionSummary: Optional[zio.aws.iot.model.JobExecutionSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobExecutionSummaryForThing = {
    import JobExecutionSummaryForThing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobExecutionSummaryForThing
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(jobExecutionSummary.map(value => value.buildAwsValue()))(
        _.jobExecutionSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobExecutionSummaryForThing.ReadOnly =
    zio.aws.iot.model.JobExecutionSummaryForThing.wrap(buildAwsValue())
}
object JobExecutionSummaryForThing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.JobExecutionSummaryForThing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobExecutionSummaryForThing =
      zio.aws.iot.model.JobExecutionSummaryForThing(
        jobId.map(value => value),
        jobExecutionSummary.map(value => value.asEditable)
      )
    def jobId: Optional[JobId]
    def jobExecutionSummary
        : Optional[zio.aws.iot.model.JobExecutionSummary.ReadOnly]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobExecutionSummary
        : ZIO[Any, AwsError, zio.aws.iot.model.JobExecutionSummary.ReadOnly] =
      AwsError.unwrapOptionField("jobExecutionSummary", jobExecutionSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionSummaryForThing
  ) extends zio.aws.iot.model.JobExecutionSummaryForThing.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.iot.model.primitives.JobId(value))
    override val jobExecutionSummary
        : Optional[zio.aws.iot.model.JobExecutionSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionSummary())
        .map(value => zio.aws.iot.model.JobExecutionSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionSummaryForThing
  ): zio.aws.iot.model.JobExecutionSummaryForThing.ReadOnly = new Wrapper(impl)
}
