package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.MaxJobExecutionsPerMin
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class JobExecutionsRolloutConfig(
    maximumPerMinute: Optional[MaxJobExecutionsPerMin] = Optional.Absent,
    exponentialRate: Optional[zio.aws.iot.model.ExponentialRolloutRate] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig = {
    import JobExecutionsRolloutConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig
      .builder()
      .optionallyWith(
        maximumPerMinute.map(value =>
          MaxJobExecutionsPerMin.unwrap(value): Integer
        )
      )(_.maximumPerMinute)
      .optionallyWith(exponentialRate.map(value => value.buildAwsValue()))(
        _.exponentialRate
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly =
    zio.aws.iot.model.JobExecutionsRolloutConfig.wrap(buildAwsValue())
}
object JobExecutionsRolloutConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobExecutionsRolloutConfig =
      zio.aws.iot.model.JobExecutionsRolloutConfig(
        maximumPerMinute.map(value => value),
        exponentialRate.map(value => value.asEditable)
      )
    def maximumPerMinute: Optional[MaxJobExecutionsPerMin]
    def exponentialRate
        : Optional[zio.aws.iot.model.ExponentialRolloutRate.ReadOnly]
    def getMaximumPerMinute: ZIO[Any, AwsError, MaxJobExecutionsPerMin] =
      AwsError.unwrapOptionField("maximumPerMinute", maximumPerMinute)
    def getExponentialRate: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.ExponentialRolloutRate.ReadOnly
    ] = AwsError.unwrapOptionField("exponentialRate", exponentialRate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig
  ) extends zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly {
    override val maximumPerMinute: Optional[MaxJobExecutionsPerMin] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumPerMinute())
        .map(value =>
          zio.aws.iot.model.primitives.MaxJobExecutionsPerMin(value)
        )
    override val exponentialRate
        : Optional[zio.aws.iot.model.ExponentialRolloutRate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exponentialRate())
        .map(value => zio.aws.iot.model.ExponentialRolloutRate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig
  ): zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly = new Wrapper(impl)
}
