package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAuditMitigationActionsExecutionsResponse(
    actionsExecutions: Optional[
      Iterable[zio.aws.iot.model.AuditMitigationActionExecutionMetadata]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse = {
    import ListAuditMitigationActionsExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse
      .builder()
      .optionallyWith(
        actionsExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionsExecutions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListAuditMitigationActionsExecutionsResponse.ReadOnly =
    zio.aws.iot.model.ListAuditMitigationActionsExecutionsResponse
      .wrap(buildAwsValue())
}
object ListAuditMitigationActionsExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.ListAuditMitigationActionsExecutionsResponse =
      zio.aws.iot.model.ListAuditMitigationActionsExecutionsResponse(
        actionsExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def actionsExecutions: Optional[
      List[zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getActionsExecutions: ZIO[Any, AwsError, List[
      zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("actionsExecutions", actionsExecutions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse
  ) extends zio.aws.iot.model.ListAuditMitigationActionsExecutionsResponse.ReadOnly {
    override val actionsExecutions: Optional[
      List[zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.actionsExecutions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.AuditMitigationActionExecutionMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse
  ): zio.aws.iot.model.ListAuditMitigationActionsExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
