package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  AuditTaskId,
  NextToken,
  Timestamp,
  MaxResults,
  FindingId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAuditMitigationActionsTasksRequest(
    auditTaskId: Optional[AuditTaskId] = Optional.Absent,
    findingId: Optional[FindingId] = Optional.Absent,
    taskStatus: Optional[zio.aws.iot.model.AuditMitigationActionsTaskStatus] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    startTime: Timestamp,
    endTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest = {
    import ListAuditMitigationActionsTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest
      .builder()
      .optionallyWith(
        auditTaskId.map(value => AuditTaskId.unwrap(value): java.lang.String)
      )(_.auditTaskId)
      .optionallyWith(
        findingId.map(value => FindingId.unwrap(value): java.lang.String)
      )(_.findingId)
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListAuditMitigationActionsTasksRequest.ReadOnly =
    zio.aws.iot.model.ListAuditMitigationActionsTasksRequest
      .wrap(buildAwsValue())
}
object ListAuditMitigationActionsTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListAuditMitigationActionsTasksRequest =
      zio.aws.iot.model.ListAuditMitigationActionsTasksRequest(
        auditTaskId.map(value => value),
        findingId.map(value => value),
        taskStatus.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        startTime,
        endTime
      )
    def auditTaskId: Optional[AuditTaskId]
    def findingId: Optional[FindingId]
    def taskStatus: Optional[zio.aws.iot.model.AuditMitigationActionsTaskStatus]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def startTime: Timestamp
    def endTime: Timestamp
    def getAuditTaskId: ZIO[Any, AwsError, AuditTaskId] =
      AwsError.unwrapOptionField("auditTaskId", auditTaskId)
    def getFindingId: ZIO[Any, AwsError, FindingId] =
      AwsError.unwrapOptionField("findingId", findingId)
    def getTaskStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AuditMitigationActionsTaskStatus
    ] = AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest
  ) extends zio.aws.iot.model.ListAuditMitigationActionsTasksRequest.ReadOnly {
    override val auditTaskId: Optional[AuditTaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.auditTaskId())
      .map(value => zio.aws.iot.model.primitives.AuditTaskId(value))
    override val findingId: Optional[FindingId] = zio.aws.core.internal
      .optionalFromNullable(impl.findingId())
      .map(value => zio.aws.iot.model.primitives.FindingId(value))
    override val taskStatus
        : Optional[zio.aws.iot.model.AuditMitigationActionsTaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatus())
        .map(value =>
          zio.aws.iot.model.AuditMitigationActionsTaskStatus.wrap(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val startTime: Timestamp =
      zio.aws.iot.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.iot.model.primitives.Timestamp(impl.endTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest
  ): zio.aws.iot.model.ListAuditMitigationActionsTasksRequest.ReadOnly =
    new Wrapper(impl)
}
