package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DeviceDefenderThingName,
  NextToken,
  ViolationId,
  Timestamp,
  MaxResults,
  MitigationActionsTaskId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDetectMitigationActionsExecutionsRequest(
    taskId: Optional[MitigationActionsTaskId] = Optional.Absent,
    violationId: Optional[ViolationId] = Optional.Absent,
    thingName: Optional[DeviceDefenderThingName] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest = {
    import ListDetectMitigationActionsExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest
      .builder()
      .optionallyWith(
        taskId.map(value =>
          MitigationActionsTaskId.unwrap(value): java.lang.String
        )
      )(_.taskId)
      .optionallyWith(
        violationId.map(value => ViolationId.unwrap(value): java.lang.String)
      )(_.violationId)
      .optionallyWith(
        thingName.map(value =>
          DeviceDefenderThingName.unwrap(value): java.lang.String
        )
      )(_.thingName)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListDetectMitigationActionsExecutionsRequest.ReadOnly =
    zio.aws.iot.model.ListDetectMitigationActionsExecutionsRequest
      .wrap(buildAwsValue())
}
object ListDetectMitigationActionsExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.ListDetectMitigationActionsExecutionsRequest =
      zio.aws.iot.model.ListDetectMitigationActionsExecutionsRequest(
        taskId.map(value => value),
        violationId.map(value => value),
        thingName.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def taskId: Optional[MitigationActionsTaskId]
    def violationId: Optional[ViolationId]
    def thingName: Optional[DeviceDefenderThingName]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getTaskId: ZIO[Any, AwsError, MitigationActionsTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getViolationId: ZIO[Any, AwsError, ViolationId] =
      AwsError.unwrapOptionField("violationId", violationId)
    def getThingName: ZIO[Any, AwsError, DeviceDefenderThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest
  ) extends zio.aws.iot.model.ListDetectMitigationActionsExecutionsRequest.ReadOnly {
    override val taskId: Optional[MitigationActionsTaskId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskId())
        .map(value =>
          zio.aws.iot.model.primitives.MitigationActionsTaskId(value)
        )
    override val violationId: Optional[ViolationId] = zio.aws.core.internal
      .optionalFromNullable(impl.violationId())
      .map(value => zio.aws.iot.model.primitives.ViolationId(value))
    override val thingName: Optional[DeviceDefenderThingName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingName())
        .map(value =>
          zio.aws.iot.model.primitives.DeviceDefenderThingName(value)
        )
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest
  ): zio.aws.iot.model.ListDetectMitigationActionsExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
