package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  ThingGroupId,
  NextToken,
  NamespaceId,
  LaserMaxResults,
  ThingGroupName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListJobsRequest(
    status: Optional[zio.aws.iot.model.JobStatus] = Optional.Absent,
    targetSelection: Optional[zio.aws.iot.model.TargetSelection] =
      Optional.Absent,
    maxResults: Optional[LaserMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    thingGroupName: Optional[ThingGroupName] = Optional.Absent,
    thingGroupId: Optional[ThingGroupId] = Optional.Absent,
    namespaceId: Optional[NamespaceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListJobsRequest
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(targetSelection.map(value => value.unwrap))(
        _.targetSelection
      )
      .optionallyWith(
        maxResults.map(value => LaserMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        thingGroupName.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.thingGroupName)
      .optionallyWith(
        thingGroupId.map(value => ThingGroupId.unwrap(value): java.lang.String)
      )(_.thingGroupId)
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListJobsRequest.ReadOnly =
    zio.aws.iot.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListJobsRequest =
      zio.aws.iot.model.ListJobsRequest(
        status.map(value => value),
        targetSelection.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        thingGroupName.map(value => value),
        thingGroupId.map(value => value),
        namespaceId.map(value => value)
      )
    def status: Optional[zio.aws.iot.model.JobStatus]
    def targetSelection: Optional[zio.aws.iot.model.TargetSelection]
    def maxResults: Optional[LaserMaxResults]
    def nextToken: Optional[NextToken]
    def thingGroupName: Optional[ThingGroupName]
    def thingGroupId: Optional[ThingGroupId]
    def namespaceId: Optional[NamespaceId]
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTargetSelection
        : ZIO[Any, AwsError, zio.aws.iot.model.TargetSelection] =
      AwsError.unwrapOptionField("targetSelection", targetSelection)
    def getMaxResults: ZIO[Any, AwsError, LaserMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getThingGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("thingGroupName", thingGroupName)
    def getThingGroupId: ZIO[Any, AwsError, ThingGroupId] =
      AwsError.unwrapOptionField("thingGroupId", thingGroupId)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListJobsRequest
  ) extends zio.aws.iot.model.ListJobsRequest.ReadOnly {
    override val status: Optional[zio.aws.iot.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.JobStatus.wrap(value))
    override val targetSelection: Optional[zio.aws.iot.model.TargetSelection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetSelection())
        .map(value => zio.aws.iot.model.TargetSelection.wrap(value))
    override val maxResults: Optional[LaserMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.LaserMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val thingGroupName: Optional[ThingGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingGroupName())
        .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val thingGroupId: Optional[ThingGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.thingGroupId())
      .map(value => zio.aws.iot.model.primitives.ThingGroupId(value))
    override val namespaceId: Optional[NamespaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListJobsRequest
  ): zio.aws.iot.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
